import logging

from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.getoptpb import ParsePbOptions
from crypta.adhoc.smart.tasks.upload_to_bb.bin.config_pb2 import TConfig
from crypta.adhoc.smart.tasks.upload_to_bb.lib import upload


logger = logging.getLogger(__name__)


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    logger.info("Upload offer data to Bigb")
    config = ParsePbOptions(TConfig)

    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)

    with yt_client.Transaction():
        yt_client.run_map(
            upload.UploadToBigbMapper(config.Logbroker.Url, config.Logbroker.Port, config.Topic, config.Tvm.SourceTvmId),
            config.SourcePath,
            config.DestPath,
            spec={
                'secure_vault': dict(TVM_SECRET=config.Tvm.Secret),
            }
        )

    logger.info("Done")
