import json
import os

from ads.bsyeti.libs.log_protos import universal_update_pb2
from protobuf_to_dict import protobuf_to_dict
from yt.wrapper import aggregator

from crypta.lib.python.lb_pusher import logbroker


@aggregator
class UploadToBigbMapper(object):
    def __init__(self, host, port, topic, tvm_id):
        self.host = host
        self.port = port
        self.topic = topic
        self.tvm_id = tvm_id

    def __call__(self, rows):
        with logbroker.PQClient(
                self.host,
                self.port,
                tvm_id=self.tvm_id,
                tvm_secret=os.environ.get('YT_SECURE_VAULT_TVM_SECRET')
        ) as client:
            with logbroker.BatchingPQWriter(client.get_writer(self.topic)) as writer:
                for row in rows:
                    entry = universal_update_pb2.TProfileUpdate()
                    entry.yandex_uid = row["crypta_id"]

                    action = entry.commands.add()
                    offer = action.add.offers.add()
                    for key in ("counter_id", "offer_id_md5", "action_bits", "update_time", "select_type"):
                        setattr(offer, key, row[key])

                    serialized = json.dumps(protobuf_to_dict(entry))
                    writer.write(serialized)
