from crypta.adhoc.socketer.lib.encdec import Decryptor, Encryptor

import argparse
import json
import os
import sys


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("-d", help="Decrypt", dest="decrypt", action="store_true", default=False)
    args = parser.parse_args()

    rsaKey = os.getenv("METRIKA_PRIVATE_KEY")
    if rsaKey is None:
        print("Set METRIKA_PRIVATE_KEY environment variable")
        raise SystemExit

    if args.decrypt:
        decryptor = Decryptor(rsaKey)
    else:
        encryptor = Encryptor(rsaKey)

    while True:
        s = sys.stdin.readline().rstrip().encode('ascii')
        if not s:
            break

        if args.decrypt:
            result = decryptor(s)
        else:
            result = encryptor(s)

        print(result.decode('ascii'))
