from collections import OrderedDict

class BrowserInfo(object):
    def __init__(self, bi):
        self.d = OrderedDict()
        isKey = False
        key = None

        splitted = iter(bi.split(":"))
        for v in splitted:
            isKey = not isKey
            if isKey:
                key = v
            else:
                if key == "t":
                    v = v + ':'.join(splitted)
                self.d[key] = v

    def __str__(self):
        return ":".join("{}:{}".format(k, v) for k, v in self.d.items())

    def __getitem__(self, key):
        return self.d[key]

    def __setitem__(self, key, value):
        self.d[key] = value

    def get(self, key, default=None):
        return self.d.get(key, default)
