from crypta.adhoc.socketer.lib.encdec import Decryptor, Encryptor
from .browserinfo import BrowserInfo

import argparse
import json
import os
import sys


privateRsaKey = os.getenv("METRIKA_PRIVATE_KEY")
testPrivateRsaKey = os.getenv("METRIKA_TEST_KEY")
encryptor = Encryptor(testPrivateRsaKey)
decryptor = Decryptor(privateRsaKey)


def reencryptDeviceinfo(bi_str):
    parsed_bi = BrowserInfo(bi_str)
    di = parsed_bi.get("di")

    if di is None:
        return bi_str

    try:
        decrypted = decryptor(di)
        encrypted = encryptor(decrypted)
        parsed_bi["di"] = encrypted.decode('ascii')
    except Exception as e:
        print(e, file=sys.stderr)
        return bi_str

    return str(parsed_bi)


def processLogString(s):
    j = json.loads(s)

    bi = j.get("browserinfo")
    if bi is None:
        return s

    j["browserinfo"] = reencryptDeviceinfo(bi)

    return json.dumps(j, separators=(',', ':'))


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("-i", help="Input file <sys.stdin>", dest="filename", default=None)
    args = parser.parse_args()

    infile = args.filename is None and sys.stdin or open(args.filename, "r")

    if privateRsaKey is None or testPrivateRsaKey is None:
        print("Set METRIKA_PRIVATE_KEY for the current and METRIKA_TEST_KEY for the new key environment variables")
        raise SystemExit

    while True:
        s = infile.readline()
        if not s : break

        print(processLogString(s))
