from Crypto.PublicKey import RSA
from Crypto.Cipher import PKCS1_v1_5
from Crypto.Cipher import AES
from base64 import b64decode, b64encode


class CryptoConstants(object):
    aesKeySize = 16
    aesIvSize = 16
    rsaBlockSize = 128


class Decryptor(CryptoConstants):
    def __init__(self, private_key):
        key = RSA.importKey(private_key)
        self.rsa = PKCS1_v1_5.new(key)

    def __call__(self, msg):
        if not msg:
            return None

        encBin = b64decode(msg)
        rsaEncrypted = encBin[:self.rsaBlockSize]
        aesEncrypted = encBin[self.rsaBlockSize:]

        rsaDecrypted = self.rsa.decrypt(rsaEncrypted, None)
        if rsaDecrypted is None:
            return None

        aesKey = rsaDecrypted[:self.aesKeySize]
        aesIv = rsaDecrypted[self.aesKeySize:self.aesKeySize + self.aesIvSize]
        aes = AES.new(aesKey, AES.MODE_CBC, aesIv)

        msg = aes.decrypt(aesEncrypted)
        padlen = msg[-1]
        msg = msg[:-padlen]

        return msg


class Encryptor(CryptoConstants):
    def __init__(self, private_or_public_key):
        key = RSA.importKey(private_or_public_key)
        self.rsa = PKCS1_v1_5.new(key)

    def __call__(self, msg, aesKey=None, aesIv=None):
        aesKey = aesKey is None and self.getRandomData(self.aesKeySize) or aesKey
        aesIv = aesIv is None and self.getRandomData(self.aesIvSize) or aesIv

        aes = AES.new(aesKey, AES.MODE_CBC, aesIv)

        padLen = (AES.block_size - len(msg)) % AES.block_size
        padding = bytes((padLen,)) * padLen

        encryptedMsg = aes.encrypt(msg + padding)
        encryptedKeys = self.rsa.encrypt(aesKey + aesIv)

        msg = encryptedKeys + encryptedMsg
        return b64encode(msg)

    def getRandomData(self, size):
        from random import randint
        return bytes(randint(0, 255) for i in range(size))
