from datetime import timedelta as dt

from crypta.lib.python.spine.consts.yt_proxy import YtProxy
from crypta.lib.python.spine.juggler import juggler_check_generator
from crypta.lib.python.spine.sandbox import sandbox_scheduler


def get_registry():
    juggler = juggler_check_generator.CryptaYtCheckGenerator(tags=["crypta-adhoc"], host="crypta-adhoc", yt_dependencies=YtProxy.Group.offline)

    sandbox = sandbox_scheduler.create_default_generator(juggler, ["ADHOC"])

    sandbox.create_run_universal_bundle_scheduler(
        bundle_name="adhoc-parse-facebook-ads",
        cmd=["{{cwd}}/crypta-adhoc-parse-facebook-ads", "--config", "{{cwd}}/config.yaml"],
        schedule_interval=dt(hours=1),
        kill_timeout=dt(hours=4),
        sequential_run=True,
    ).check(crit_time=dt(days=2))

    sandbox.create_run_universal_bundle_scheduler(
        bundle_name="adhoc-history",
        cmd=["{{cwd}}/crypta-adhoc-history", "--config", "{{cwd}}/config.yaml"],
        schedule_interval=dt(hours=1),
        kill_timeout=dt(hours=24),
        sequential_run=True,
    ).check(crit_time=dt(days=2))

    return juggler
