from crypta.affinitive_geo.services.org_embeddings.lib.utils import config
from crypta.lib.python import templater
from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.profile.lib import date_helpers


banner_shows_clicks_query = u'''
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$chevent = (
    SELECT DISTINCT
        ch.cryptaidv2 AS crypta_id,
        ch.logid AS logid,
        ch.bannerid AS bannerid,
        ch.groupbannerid AS groupbannerid,
        ch.regionid AS regionid,
        CASE
            WHEN ch.countertype == 1 THEN 'show'
            WHEN ch.countertype == 2 THEN 'click'
            ELSE Null
        END AS action_type,
    FROM RANGE(
        `{{chevent_log}}`,
        `{{first_date}}`,
        `{{last_date}}`
    ) AS ch
    WHERE
        ch.placeid == 542
        AND ch.fraudbits == 0
        AND ch.countertype IN (1, 2)
        AND ch.cryptaidv2 IS NOT Null
        AND ch.cryptaidv2 != 0
);

INSERT INTO `{{shows_output_table}}`
WITH TRUNCATE

SELECT * WITHOUT action_type
FROM $chevent
WHERE action_type == 'show'
ORDER BY crypta_id;

INSERT INTO `{{clicks_output_table}}`
WITH TRUNCATE

SELECT * WITHOUT action_type
FROM $chevent
WHERE action_type == 'click'
ORDER BY crypta_id;

$showed_banners = (
    SELECT DISTINCT
        bannerid,
        groupbannerid,
    FROM $chevent
);

INSERT INTO `{{active_banners_output_table}}`
WITH TRUNCATE

SELECT
    showed_banners.*,
    banner_info.Body AS banner_body,
FROM $showed_banners AS showed_banners
INNER JOIN `{{banner_desc_table}}` AS banner_info
ON showed_banners.bannerid == banner_info.BannerID
ORDER BY bannerid;
'''


def get(yt_client, yql_client, date):
    with NirvanaTransaction(yt_client) as transaction:
        yql_client.execute(
            templater.render_template(
                banner_shows_clicks_query,
                vars={
                    'first_date': date_helpers.get_date_from_past(date, days=config.DAYS_BACK_TO_START_GETTING_CHEVENT_INFO),
                    'last_date': date_helpers.get_yesterday(date),
                    'chevent_log': config.CHEVENT_LOG_DIR,
                    'banner_desc_table': config.BANNER_DESCRIPTION_TABLE,
                    'shows_output_table': config.CHEVENT_SHOWS_TABLE,
                    'clicks_output_table': config.CHEVENT_CLICKS_TABLE,
                    'active_banners_output_table': config.ACTIVE_BANNERS_TABLE,
                },
            ),
            title='YQL affinitive geo calculate chevent shows and clicks',
            transaction=str(transaction.transaction_id),
        )
