import json
import os

from crypta.affinitive_geo.services.org_embeddings.lib.utils import config
from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils import utils as lal_utils


def get(yt_client, input_table, output_table):
    with NirvanaTransaction(yt_client):
        features_mapping = json.loads(
            next(yt_client.read_file(os.path.join(config.LOOKALIKE_VERSION_DIR, 'segments_dict.json')))
        )

        lal_utils.get_segment_dssm_features(
            yt_client=yt_client,
            segments_with_description_table=input_table,
            segment_dssm_features_table=output_table,
            features_mapping=features_mapping,
        )
