import os

from crypta.affinitive_geo.services.org_embeddings.lib.utils import config
from crypta.lib.python import templater
from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils import utils as lal_utils


def get(yt_client, yql_client, input_table, output_table):
    with NirvanaTransaction(yt_client) as transaction:
        yql_client.execute(
            query=templater.render_template(
                lal_utils.get_segments_embeddings_query_template,
                vars={
                    'model_path': yt_client.get_attribute(
                        os.path.join(config.LOOKALIKE_VERSION_DIR, 'dssm_model.applier'),
                        config.DSSM_MODEL_SANDBOX_LINK,
                    ),
                    'segments_dssm_features_table': input_table,
                    'segments_dssm_vectors_table': output_table,
                }
            ),
            transaction=str(transaction.transaction_id),
            title='YQL affinitive geo get dssm vectors',
        )
