import os

from crypta.affinitive_geo.services.org_embeddings.lib.utils import config
from crypta.lib.python import templater
from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lookalike.lib.python.utils import utils as lal_utils
from crypta.profile.lib import date_helpers


get_orgvisits_for_desc_query = u'''
$orgvisits_flatten = (
    SELECT
        crypta_id,
        permalink,
    FROM `{{aggregated_orgvisits_table}}`
    FLATTEN LIST BY permalinks AS permalink
);

INSERT INTO `{{orgvisits_for_description_table}}`
WITH TRUNCATE

SELECT
    CAST(crypta_id AS String) AS IdValue,
    'crypta_id' AS IdType,
    CAST(permalink AS String) AS GroupID,
FROM $orgvisits_flatten
ORDER BY GroupID;

$orgs = (
    SELECT DISTINCT permalink
    FROM $orgvisits_flatten
);

INSERT INTO `{{orgs_info_output_table}}`
WITH TRUNCATE

SELECT
    orgs.permalink AS permalink,
    COALESCE(info.name, '') AS name,
    info.publishing_status AS publishing_status,
    info.address AS address,
    COALESCE(info.country_name, '') AS country_name,
    Geo::RoundRegionById(info.geo_id, 'region').id AS region_id,
    Geo::RoundRegionById(info.geo_id, 'region').name AS region_name,
    info.main_rubric_id AS main_rubric_id,
    COALESCE(info.main_rubric_name_ru, 'прочее') AS main_rubric_name_ru,
    info.lat AS lat,
    info.lon AS lon,
    info.geo_id AS geo_id,
FROM $orgs AS orgs
INNER JOIN `{{orgs_info_input_table}}` AS info
USING(permalink)
ORDER BY permalink;
'''


def get(yt_client, yql_client, date):
    with NirvanaTransaction(yt_client) as transaction:
        lal_utils.copy_last_lal_model(
            yt_client=yt_client,
            output_dir=config.LOOKALIKE_VERSION_DIR,
        )

        yql_client.execute(
            templater.render_template(
                get_orgvisits_for_desc_query,
                vars={
                    'aggregated_orgvisits_table': os.path.join(
                        config.AGGREGATED_ORGVISITS_DIR,
                        date_helpers.get_date_from_past(date, days=config.DAYS_BACK_TO_GET_ORGVISITS),
                    ),
                    'orgs_info_input_table': config.COMPANY_INFO_PRETTY_FORMAT_TABLE,
                    'orgvisits_for_description_table': config.ORGVISITS_FOR_DESCRIPTION_TABLE,
                    'orgs_info_output_table': config.ORGS_INFO_TABLE,
                },
            ),
            title='YQL affinitive geo get orgvisits for description',
            transaction=str(transaction.transaction_id),
        )
