from crypta.affinitive_geo.services.org_embeddings.lib.utils import config
from crypta.lib.python import templater
from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction


get_regions_for_desc_query = u'''
$region_orgs = (
    SELECT CAST(region_id AS String) AS GroupID
    FROM `{{orgs_info_table}}`
    GROUP BY region_id
    HAVING COUNT(*) >= {{min_suitable_orgs_per_region}}
);

$filtered_userdata = (
    SELECT
        CryptaID AS IdValue,
        'crypta_id' AS IdType,
        CAST(Geo::RoundRegionById(CAST(Attributes.Region AS Int32), 'region').id AS String) AS GroupID,
    FROM `{{cryptaid_userdata_table}}`
);

INSERT INTO `{{regions_for_description_table}}`
WITH TRUNCATE

SELECT userdata.*
FROM $filtered_userdata AS userdata
INNER JOIN $region_orgs AS regions
USING(GroupID)
ORDER BY GroupID;
'''


def get(yt_client, yql_client):
    with NirvanaTransaction(yt_client) as transaction:
        yql_client.execute(
            templater.render_template(
                get_regions_for_desc_query,
                vars={
                    'min_suitable_orgs_per_region': config.MIN_SUITABLE_ORGS_PER_REGION,
                    'orgs_info_table': config.ORGS_INFO_TABLE,
                    'cryptaid_userdata_table': config.CRYPTAID_USERDATA_TABLE,
                    'regions_for_description_table': config.REGIONS_FOR_DESCRIPTION_TABLE,
                },
            ),
            title='YQL affinitive geo get regions for description',
            transaction=str(transaction.transaction_id),
        )
