from crypta.affinitive_geo.services.org_embeddings.lib.utils import config
from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.lib.python.yt import yt_helpers
from crypta.lookalike.lib.python.utils import fields
from crypta.siberia.bin.common.yt_describer.proto.yt_describer_config_pb2 import TYtDescriberConfig
from crypta.siberia.bin.common.yt_describer.py import describe


def get(yt_client, input_table, output_table):
    with NirvanaTransaction(yt_client) as transaction:
        description_config = TYtDescriberConfig(
            TmpDir=config.COMMON_TMP_DIRECTORY,
            InputTable=input_table,
            OutputTable=output_table,
        )

        yt_helpers.create_empty_table(
            yt_client=yt_client,
            path=output_table,
            schema={
                fields.group_id: 'string',
                fields.stats: 'string',
            },
            additional_attributes={'optimize_for': 'scan'},
            force=True,
        )

        describe(yt_client, transaction, description_config)
