from crypta.affinitive_geo.services.org_embeddings.lib.utils import config


normalize_vector_query = u'''
$normalize_vector = ($vector) -> {
    $norm = COALESCE(Math::Sqrt(ListSum(ListMap($vector, ($elem) -> (Math::Pow($elem, 2))))), 1);
    $normalized_vector = ListMap(
        $vector,
        ($elem) -> ($elem / $norm)
    );

    RETURN $normalized_vector;
};
'''

dot_product_query = u'''
$dot_product = ($vec1, $vec2) -> (
    ListSum(ListMap(ListZip($vec1, $vec2), ($elem) -> ($elem.0 * $elem.1)))
);
'''


def replaced_for_custom_output_dir(path):
    return isinstance(path, str) and (
        path.startswith(config.AFFINITIVE_GEO_DIR) and
        not path.startswith(config.ORGVISITS_DIR)
    )


def replace_working_dir(production_path, custom_output_dir):
    return production_path.replace(config.AFFINITIVE_GEO_DIR, custom_output_dir)


def update_config_for_custom_output_dir(custom_output_dir):
    config.__dict__.update({
        key: replace_working_dir(path, custom_output_dir)
        for key, path in config.__dict__.items() if replaced_for_custom_output_dir(path)
    })
