#!/bin/bash

if [ -z ${DEPLOY_BOX_ID+x} ];
then
    readonly xmx=`echo "${QLOUD_JAVA_OPTIONS:-}" | grep -o -e "-Xmx[^ ]*"`;
else
    correction=10 # -1000M for system
    if [ ${DEPLOY_LOGS_ENDPOINT} ]; then
        correction=$(expr $correction + 5); # -500M for logs
    fi
    memory_limit=$(curl -s localhost:1/pod_attributes | jq .box_resource_requirements.docker.memory.memory_limit_bytes);
    java_limit="$(expr $memory_limit / 1000 / 1000 / 100 - $correction)00";
    readonly xmx=-Xmx${java_limit}m;
fi

readonly ipv6="-Djava.net.preferIPv6Addresses=true"
readonly utf="-Dfile.encoding=UTF-8"
java ${xmx} ${ipv6} ${utf} -Djava.library.path="/root/api/api" -cp "/root/api/api.jar:/root/api/api/*" ru.yandex.crypta.api.Main
