#!/bin/bash

function assert_has() {
    if ! [ -x "$(command -v $1)" ]; then
        echo "$1 is not available" >&2
        exit 1
    fi
}

function vault() {
    ../../ya vault get version -j $1 | ../../ya tool jq -r ".value.password // .value.secret"
}

# Deprecated
function secdist() {
    ssh -q "secdist.yandex.net" "cat \"/repo/projects/crypta/$1\""
}

function local() {
    cat "$1"
}

function realpath() {
    echo "$(cd "$(dirname "$1")"; pwd)/$(basename "$1")"
}

function geodata() {
    url=`curl -s -X GET --header "Authorization: OAuth ${SANDBOX_OAUTH_TOKEN}" "https://sandbox.yandex-team.ru/api/v1.0/resource?limit=1&offset=0&order=-id&type=GEODATA5BIN_STABLE&state=READY" -H "accept: application/json; charset=utf-8" | ../../ya tool jq -r ".items [0] .http .proxy"`
    wget --header "Authorization: OAuth ${SANDBOX_OAUTH_TOKEN}" -O geodata.bin ${url}
    realpath geodata.bin
}

assert_has wget

cat << EOF
CRYPTA_ENVIRONMENT=testing
POSTGRES_CONNECTION_STRING=jdbc:postgresql://testing.database.crypta.yandex.net:6432/cryptadbtest?sslmode=require&ssl=true&prepareThreshold=0&socketTimeout=2&loginTimeout=1
POSTGRES_USERNAME=crypta
POSTGRES_PASSWORD=$(vault ver-01csvzfj53v0tpttj1dzmfwcea)
YT_PROXY=hahn.yt.yandex.net
YT_TOKEN=$(local ~/.yt/token)
AWAPS_PASSWORD=$(vault ver-01csvzjj4a79kzred5n64b6jws)
AWAPS_USER=robot-unicorn
SMTP_PASSWORD=$(vault ver-01csvzjj4a79kzred5n64b6jws)
SMTP_USER=robot-unicorn
BLACKBOX_URL=https://pass-test.yandex.ru/blackbox
SANDBOX_OAUTH_TOKEN=${SANDBOX_OAUTH_TOKEN}
SOLOMON_TOKEN=$(vault ver-01e63xgmhqps32zj6n69q577dt)
YQL_TOKEN=$(local ~/.yt/token)
YQL_USER=${USER}
REACTOR_TOKEN=${REACTOR_TOKEN}
S3_ACCESS_KEY_ID=$(vault ver-01csvzhmjfssbzy01gcenk15b7)
S3_SECRET_KEY=$(vault ver-01csvzhkdt2n73rjg494vb7qvg)
TANKER_TOKEN=...
TVM_ID=2000761
TVM_SECRET=$(vault ver-01csvzewt64fx0929dvvyb49z6)
GEODATA=$(geodata)
YT_RPC_USER=robot-crypta-testing
REDIS_SENTINELS=man-d1eye7ou5sdtj5v6.db.yandex.net:26379
REDIS_MASTERNAME=crypta_redis_test
REDIS_PASSWORD=$(vault ver-01f35grtwc22q5nsrb4ma38rsf)
DISABLE_IDM=yes
DISABLE_AUTH=yes
DISABLE_SCHEDULING=yes
DISABLE_TVM=yes
DEBUG_USER_NAME=${USER}
EOF
