import datetime

from crypta.lib.python.solomon.proto import alert_pb2
from crypta.lib.python.spine.consts import environment
from crypta.lib.python.spine.juggler import consts
from crypta.lib.python.spine.juggler.juggler_check_generator import CryptaYtCheckGenerator
from crypta.lib.python.spine.solomon import solomon_check_generator


def add_500_check(solomon, threshold, resource_class=None, method=None):
    selectors = {"sensor": "request.response.500"}
    if resource_class is not None:
        selectors["class"] = resource_class

    if method is not None:
        selectors["method"] = method

    solomon.get_sensor(selectors).create_threshold_check(
        aggregation=alert_pb2.MAX,
        predicate=alert_pb2.GT,
        threshold=threshold,
        period=datetime.timedelta(minutes=1),
        description="Code 500: {{ pointValue }}",
    ).add_nodata_mode(consts.NoDataMode.force_ok)


def get_registry():
    juggler_check_generator = CryptaYtCheckGenerator(
        warn_limit=0,
        crit_limit=0,
        child_group="crypta@stage=crypta-api",
        child_group_type=consts.GroupType.deploy,
        tags=["crypta-api"],
        host="api.crypta.yandex.net"
    )

    juggler_check_generator.icmpping().set_crit_limit(1)

    solomon = solomon_check_generator.ServiceSolomonCheckGenerator(
        juggler_check_generator,
        project="crypta_api",
        service="metrics",
        cluster=environment.PRODUCTION,
    )

    add_500_check(solomon, 1)
    add_500_check(solomon, 0.05, resource_class="ru.yandex.crypta.api.rest.resource.ext.direct_ca.DirectCaResource", method="getCaDescription")
    add_500_check(solomon, 0.05, resource_class="ru.yandex.crypta.api.rest.resource.ext.lilucrm.LiluCrmResource", method="getGraphForLiluCrm")

    return juggler_check_generator
