package ru.yandex.crypta.api;

import io.swagger.models.Swagger;
import org.glassfish.jersey.internal.inject.AbstractBinder;

import ru.yandex.crypta.api.config.DependencyInjection;
import ru.yandex.crypta.api.config.Scheduling;
import ru.yandex.crypta.api.config.ServiceProvider;
import ru.yandex.crypta.api.proto.TApiServerConfig;
import ru.yandex.crypta.api.rest.RestRoot;
import ru.yandex.crypta.common.ws.AbstractServer;
import ru.yandex.crypta.common.ws.DefaultWsApplication;
import ru.yandex.crypta.config.ApiSwagger;
import ru.yandex.crypta.config.CommandLine;
import ru.yandex.crypta.config.Initialization;

public class Main extends DefaultWsApplication {

    protected TApiServerConfig config;
    protected AbstractServer server;
    private static final String API_TITLE = "Crypta API";
    private static final String API_DESCRIPTION = "Provides ways to interact with Crypta";

    protected Main(String[] args) {
        TApiServerConfig config = (TApiServerConfig) CommandLine.parseArgs(TApiServerConfig.newBuilder(), args);
        this.config = updateConfig(config);
        this.server = createServer();
    }

    public static void main(String[] args) {
        Initialization.run(Main.class);
        new Main(args).run();
    }

    protected TApiServerConfig updateConfig(TApiServerConfig config) {
        return config;
    }

    private void run() {
        startServer();
        Scheduling.setUp(config, getServiceProvider());
    }

    public void startServer() {
        server.start();
    }

    protected ServiceProvider getServiceProvider() {
        return server.getResourceConfig().getInjectionManager()::getInstance;
    }

    @Override
    protected String getPrefix() {
        return config.getHttp().getPrefix();
    }

    @Override
    protected int getPort() {
        return config.getHttp().getPort();
    }

    @Override
    protected void bindCustom(AbstractBinder binder) {
        DependencyInjection.bind(config, binder);
    }

    @Override
    protected Class<?> getRestRootClass() {
        return RestRoot.class;
    }

    @Override
    protected Swagger getSwagger() {
        return ApiSwagger.process(Main.class, API_TITLE, API_DESCRIPTION, createSwagger());
    }

}
