package ru.yandex.crypta.api.config;

import javax.inject.Singleton;

import org.glassfish.jersey.internal.inject.AbstractBinder;

import ru.yandex.crypta.api.migrations.Migrations;
import ru.yandex.crypta.api.proto.TApiServerConfig;
import ru.yandex.crypta.api.rest.resource.graph.GraphServices;
import ru.yandex.crypta.audience.AudienceService;
import ru.yandex.crypta.audience.DefaultAudienceService;
import ru.yandex.crypta.clients.audience.AudienceClient;
import ru.yandex.crypta.clients.audience.DefaultAudienceClient;
import ru.yandex.crypta.clients.bigb.BigbClient;
import ru.yandex.crypta.clients.bigb.DefaultBigbClient;
import ru.yandex.crypta.clients.bigb.ProfileService;
import ru.yandex.crypta.clients.bigb.PublicProfileService;
import ru.yandex.crypta.clients.blackbox.BlackboxClient;
import ru.yandex.crypta.clients.blackbox.HttpBlackboxClient;
import ru.yandex.crypta.clients.blackbox.NoAuthHttpBlackboxClient;
import ru.yandex.crypta.clients.geobase.BasicGeobaseClient;
import ru.yandex.crypta.clients.geobase.GeobaseClient;
import ru.yandex.crypta.clients.graphite.DefaultGraphiteClient;
import ru.yandex.crypta.clients.graphite.GraphiteClient;
import ru.yandex.crypta.clients.idm.JooqRoleService;
import ru.yandex.crypta.clients.idm.RoleService;
import ru.yandex.crypta.clients.pgaas.HikariPostgresClient;
import ru.yandex.crypta.clients.pgaas.PostgresClient;
import ru.yandex.crypta.clients.reactor.ReactorClient;
import ru.yandex.crypta.clients.reactor.RestReactorClient;
import ru.yandex.crypta.clients.redis.JedisRedisClient;
import ru.yandex.crypta.clients.redis.RedisClient;
import ru.yandex.crypta.clients.sandbox.RestSandboxClient;
import ru.yandex.crypta.clients.sandbox.SandboxClient;
import ru.yandex.crypta.clients.staff.RestStaffClient;
import ru.yandex.crypta.clients.staff.StaffClient;
import ru.yandex.crypta.clients.startrek.CryptaStartrekClient;
import ru.yandex.crypta.clients.startrek.DefaultStartrekClient;
import ru.yandex.crypta.clients.step.RestStepEventClient;
import ru.yandex.crypta.clients.step.StepEventClient;
import ru.yandex.crypta.clients.tvm.AudienceTvmClient;
import ru.yandex.crypta.clients.tvm.CryptaidorAudienceTvmClient;
import ru.yandex.crypta.clients.tvm.DefaultTvmClient;
import ru.yandex.crypta.clients.tvm.IDefaultTvmClient;
import ru.yandex.crypta.clients.tvm.StubAudienceTvmClient;
import ru.yandex.crypta.clients.tvm.StubTvmClient;
import ru.yandex.crypta.clients.tvm.TvmClient;
import ru.yandex.crypta.clients.tvm.TvmClientIcebergImpl;
import ru.yandex.crypta.clients.tvm.UnicornAudienceTvmClient;
import ru.yandex.crypta.clients.yabs.HttpYabsClient;
import ru.yandex.crypta.clients.yabs.YabsClient;
import ru.yandex.crypta.common.ws.config.ConfigUtils;
import ru.yandex.crypta.graph.api.service.PublicGraphService;
import ru.yandex.crypta.graph.api.service.PublicYtGrapthService;
import ru.yandex.crypta.graph.api.service.SoupConfigGraphService;
import ru.yandex.crypta.graph.api.service.VultureGraphService;
import ru.yandex.crypta.graph.api.service.YtAntifraudSoupGraphService;
import ru.yandex.crypta.graph.api.service.YtGraphEngineService;
import ru.yandex.crypta.graph.api.service.YtHouseholdsGraphService;
import ru.yandex.crypta.graph.api.service.YtHumanMatchingGraphService;
import ru.yandex.crypta.graph.api.service.YtProtoExportGraphService;
import ru.yandex.crypta.graph.api.service.YtRTGraphEngineService;
import ru.yandex.crypta.graph.api.service.YtSoupGraphService;
import ru.yandex.crypta.graph.api.service.YtSoupyIndeviceGraphService;
import ru.yandex.crypta.graph.api.service.YtV1GraphService;
import ru.yandex.crypta.graph.api.service.ids.IdsStorageService;
import ru.yandex.crypta.graph.api.service.ids.YtIdsStorageService;
import ru.yandex.crypta.graph.api.service.settings.SoupConfigGraphSettings;
import ru.yandex.crypta.graph.api.service.settings.VultureGraphSettings;
import ru.yandex.crypta.graph.api.service.settings.YtAntifraudSoupGraphSettings;
import ru.yandex.crypta.graph.api.service.settings.YtGraphEngineSettings;
import ru.yandex.crypta.graph.api.service.settings.YtHouseholdsGraphSettings;
import ru.yandex.crypta.graph.api.service.settings.YtHumanMatchingGraphSettings;
import ru.yandex.crypta.graph.api.service.settings.YtProtoExportGraphSettings;
import ru.yandex.crypta.graph.api.service.settings.YtRTGraphEngineSettings;
import ru.yandex.crypta.graph.api.service.settings.YtSoupGraphSettings;
import ru.yandex.crypta.graph.api.service.settings.YtSoupyIndeviceGraphSettings;
import ru.yandex.crypta.graph.api.service.settings.YtV1GraphSettings;
import ru.yandex.crypta.graph.api.utils.GraphDiffHelper;
import ru.yandex.crypta.lab.LabService;
import ru.yandex.crypta.lab.custom_audience.CustomAudienceClient;
import ru.yandex.crypta.lab.rule_estimates.RuleEstimatorClient;
import ru.yandex.crypta.lab.siberia.SiberiaClient;
import ru.yandex.crypta.lab.startrek.DefaultLabStartrekService;
import ru.yandex.crypta.lab.startrek.LabStartrekService;
import ru.yandex.crypta.lab.yt.DefaultLabService;
import ru.yandex.crypta.lib.mds.DefaultMdsService;
import ru.yandex.crypta.lib.mds.MdsService;
import ru.yandex.crypta.lib.schedulers.Schedulers;
import ru.yandex.crypta.lib.yt.DefaultYtService;
import ru.yandex.crypta.lib.yt.YtService;
import ru.yandex.crypta.search.DefaultSearchService;
import ru.yandex.crypta.search.MatchersRepository;
import ru.yandex.crypta.search.SearchService;
import ru.yandex.crypta.search.cache.RedisSearchCacheService;
import ru.yandex.crypta.search.cache.SearchCacheService;
import ru.yandex.crypta.search.history.RedisUserHistoryService;
import ru.yandex.crypta.search.history.UserHistoryService;
import ru.yandex.crypta.search.keyword.DefaultKeywordsService;
import ru.yandex.crypta.search.keyword.KeywordsService;
import ru.yandex.crypta.service.bmcategory.BMCategoryService;
import ru.yandex.crypta.service.bmcategory.DefaultBMCategoryService;
import ru.yandex.crypta.service.dmp.DmpService;
import ru.yandex.crypta.service.dmp.YtDmpService;
import ru.yandex.crypta.service.domains.DomainService;
import ru.yandex.crypta.service.domains.TargetDomainService;
import ru.yandex.crypta.service.entity.extractor.EntityExtractorService;
import ru.yandex.crypta.service.entity.extractor.YtEntityExtractorService;
import ru.yandex.crypta.service.experiments.DefaultExperimentsService;
import ru.yandex.crypta.service.experiments.ExperimentsService;
import ru.yandex.crypta.service.experiments.StubExperimentsService;
import ru.yandex.crypta.service.ltp.client.LtpViewerClient;
import ru.yandex.crypta.service.me.ProfileMappingService;
import ru.yandex.crypta.service.pages.DefaultPageService;
import ru.yandex.crypta.service.pages.PageService;
import ru.yandex.crypta.service.public_profile.PublicProfileMappingService;
import ru.yandex.crypta.service.staff.DefaultStaffService;
import ru.yandex.crypta.service.staff.StaffService;
import ru.yandex.crypta.service.task.JugglerTaskStatusReporter;
import ru.yandex.crypta.service.task.ReactorTaskStatusService;
import ru.yandex.crypta.service.task.SolomonTaskStatusReporter;
import ru.yandex.crypta.service.task.StepTaskStatusService;
import ru.yandex.crypta.service.task.TaskStatusService;
import ru.yandex.crypta.service.tx.DefaultTxService;
import ru.yandex.crypta.service.tx.TxService;
import ru.yandex.crypta.service.useragents.JooqUseragentsService;
import ru.yandex.crypta.service.useragents.UseragentsService;

public class DependencyInjection {

    private DependencyInjection() {
    }

    public static void bind(TApiServerConfig config, AbstractBinder binder) {
        bindInternalServices(binder);
        bindExternalClients(binder);
        bindGraphServices(binder);
        bindConfig(config, binder);
        bindTvm(config, binder);
        bindAuth(config, binder);
        bindExperiments(config, binder);
        bindSearchServices(binder);

        binder.bind(DefaultTxService.class).to(TxService.class).in(Singleton.class);
        binder.bind(DefaultYtService.class).to(YtService.class).in(Singleton.class);
        binder.bind(JooqRoleService.class).to(RoleService.class).in(Singleton.class);
        binder.bind(JooqUseragentsService.class).to(UseragentsService.class).in(Singleton.class);
        binder.bind(YtDmpService.class).to(DmpService.class).in(Singleton.class);
        binder.bind(YtEntityExtractorService.class).to(EntityExtractorService.class).in(Singleton.class);
        binder.bind(DefaultBMCategoryService.class).to(BMCategoryService.class).in(Singleton.class);
        binder.bind(DefaultPageService.class).to(PageService.class).in(Singleton.class);
        binder.bind(DefaultStaffService.class).to(StaffService.class).in(Singleton.class);
        binder.bind(TargetDomainService.class).to(DomainService.class).in(Singleton.class);
        binder.bind(DefaultAudienceService.class).to(AudienceService.class).in(Singleton.class);
        binder.bind(DefaultMdsService.class).to(MdsService.class).in(Singleton.class);
        binder.bind(ProfileMappingService.class).to(ProfileService.class).in(Singleton.class);
        binder.bind(PublicProfileMappingService.class).to(PublicProfileService.class).in(Singleton.class);
        binder.bind(DefaultLabStartrekService.class).to(LabStartrekService.class).in(Singleton.class);
        binder.bind(DefaultLabService.class).to(LabService.class).in(Singleton.class);
        binder.bind(DefaultKeywordsService.class).to(KeywordsService.class).in(Singleton.class);
        binder.bind(PublicYtGrapthService.class).to(PublicGraphService.class).in(Singleton.class);

        // task status
        binder.bindAsContract(SolomonTaskStatusReporter.class).in(Singleton.class);
        binder.bindAsContract(JugglerTaskStatusReporter.class).in(Singleton.class);
        binder.bind(StepTaskStatusService.class).named("step").to(TaskStatusService.class).in(Singleton.class);
        binder.bind(ReactorTaskStatusService.class).named("reactor").to(TaskStatusService.class).in(Singleton.class);
    }

    private static void bindSearchServices(AbstractBinder binder) {
        binder.bindAsContract(MatchersRepository.class).in(Singleton.class);
        binder.bind(DefaultSearchService.class).to(SearchService.class).in(Singleton.class);
        binder.bind(RedisSearchCacheService.class).to(SearchCacheService.class).in(Singleton.class);
        binder.bind(RedisUserHistoryService.class).to(UserHistoryService.class).in(Singleton.class);
    }

    private static void bindExperiments(TApiServerConfig config, AbstractBinder binder) {
        if (config.getFeatures().getDisableExperiments()) {
            binder.bind(StubExperimentsService.class).to(ExperimentsService.class).in(Singleton.class);
        } else {
            binder.bind(DefaultExperimentsService.class).to(ExperimentsService.class).in(Singleton.class);
        }
    }

    private static void bindExternalClients(AbstractBinder binder) {
        binder.bind(HikariPostgresClient.class).to(PostgresClient.class).in(Singleton.class);
        binder.bind(DefaultGraphiteClient.class).to(GraphiteClient.class).in(Singleton.class);
        binder.bind(RestSandboxClient.class).to(SandboxClient.class).in(Singleton.class);
        binder.bind(RestStaffClient.class).to(StaffClient.class).in(Singleton.class);
        binder.bind(BasicGeobaseClient.class).to(GeobaseClient.class).in(Singleton.class);
        binder.bind(HttpYabsClient.class).to(YabsClient.class).in(Singleton.class);
        binder.bind(DefaultBigbClient.class).to(BigbClient.class).in(Singleton.class);
        binder.bind(RestStepEventClient.class).to(StepEventClient.class).in(Singleton.class);
        binder.bind(RestReactorClient.class).to(ReactorClient.class).in(Singleton.class);
        binder.bindAsContract(SiberiaClient.class).in(Singleton.class);
        binder.bindAsContract(CustomAudienceClient.class).in(Singleton.class);
        binder.bindAsContract(LtpViewerClient.class).in(Singleton.class);
        binder.bindAsContract(RuleEstimatorClient.class).in(Singleton.class);
        binder.bind(DefaultAudienceClient.class).to(AudienceClient.class).in(Singleton.class);
        binder.bind(DefaultStartrekClient.class).to(CryptaStartrekClient.class).in(Singleton.class);
        binder.bind(JedisRedisClient.class).to(RedisClient.class).in(Singleton.class);
    }

    private static void bindInternalServices(AbstractBinder binder) {
        binder.bindAsContract(Schedulers.class).in(Singleton.class);
        binder.bindAsContract(Migrations.class).in(Singleton.class);
    }

    private static void bindGraphServices(AbstractBinder binder) {
        binder.bindAsContract(YtHumanMatchingGraphService.class).in(Singleton.class);
        binder.bindAsContract(YtHumanMatchingGraphSettings.class).in(Singleton.class);

        binder.bindAsContract(YtGraphEngineService.class).in(Singleton.class);
        binder.bindAsContract(YtGraphEngineSettings.class).in(Singleton.class);

        binder.bindAsContract(YtRTGraphEngineService.class).in(Singleton.class);
        binder.bindAsContract(YtRTGraphEngineSettings.class).in(Singleton.class);

        binder.bindAsContract(YtV1GraphService.class).in(Singleton.class);
        binder.bindAsContract(YtV1GraphSettings.class).in(Singleton.class);

        binder.bindAsContract(YtHouseholdsGraphSettings.class).in(Singleton.class);
        binder.bindAsContract(YtHouseholdsGraphService.class).in(Singleton.class);

        binder.bindAsContract(YtSoupGraphService.class).in(Singleton.class);
        binder.bindAsContract(YtSoupGraphSettings.class).in(Singleton.class);

        binder.bindAsContract(YtAntifraudSoupGraphSettings.class).in(Singleton.class);
        binder.bindAsContract(YtAntifraudSoupGraphService.class).in(Singleton.class);

        binder.bindAsContract(VultureGraphService.class).in(Singleton.class);
        binder.bindAsContract(VultureGraphSettings.class).in(Singleton.class);

        binder.bindAsContract(SoupConfigGraphService.class).in(Singleton.class);
        binder.bindAsContract(SoupConfigGraphSettings.class).in(Singleton.class);

        binder.bindAsContract(YtProtoExportGraphService.class).in(Singleton.class);
        binder.bindAsContract(YtProtoExportGraphSettings.class).in(Singleton.class);

        binder.bindAsContract(YtSoupyIndeviceGraphService.class).in(Singleton.class);
        binder.bindAsContract(YtSoupyIndeviceGraphSettings.class).in(Singleton.class);

        binder.bindAsContract(GraphDiffHelper.class).in(Singleton.class);
        binder.bindAsContract(GraphServices.class).in(Singleton.class);

        binder.bind(YtIdsStorageService.class).to(IdsStorageService.class).in(Singleton.class);
    }

    private static void bindTvm(TApiServerConfig config, AbstractBinder binder) {
        if (config.getDevelopment().getDisableTvm()) {
            binder.bind(StubTvmClient.class).to(TvmClient.class).in(Singleton.class);
            binder.bind(StubAudienceTvmClient.class).named("unicornTvm").to(AudienceTvmClient.class).in(Singleton.class);
            binder.bind(StubAudienceTvmClient.class).named("cryptaidorTvm").to(AudienceTvmClient.class).in(Singleton.class);
        } else {
            binder.bind(TvmClientIcebergImpl.class).to(TvmClient.class).in(Singleton.class);
            binder.bind(UnicornAudienceTvmClient.class).named("unicornTvm").to(AudienceTvmClient.class).in(Singleton.class);
            binder.bind(CryptaidorAudienceTvmClient.class).named("cryptaidorTvm").to(AudienceTvmClient.class).in(Singleton.class);
        }

        binder.bind(DefaultTvmClient.class).to(IDefaultTvmClient.class).in(Singleton.class);

    }

    private static void bindAuth(TApiServerConfig config, AbstractBinder binder) {
        if (config.getDevelopment().getDisableAuth()) {
            binder.bind(NoAuthHttpBlackboxClient.class).to(BlackboxClient.class).in(Singleton.class);
        } else {
            binder.bind(HttpBlackboxClient.class).to(BlackboxClient.class).in(Singleton.class);
        }
    }

    private static void bindConfig(TApiServerConfig config, AbstractBinder binder) {
        binder.bind(config)
                .to(TApiServerConfig.class)
                .in(Singleton.class);

        ConfigUtils.bindFields(config, binder);
    }
}
