package ru.yandex.crypta.api.migrations;

import java.util.List;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.flywaydb.core.Flyway;
import org.glassfish.jersey.internal.inject.InjectionManager;

import ru.yandex.crypta.clients.pgaas.PostgresClient;
import ru.yandex.crypta.lab.migrations.LabMigrations;

@Singleton
public class Migrations {

    private final PostgresClient sql;
    private final InjectionManager injectionManager;

    @Inject
    public Migrations(PostgresClient sql, InjectionManager locator) {
        this.sql = sql;
        this.injectionManager = locator;
    }

    public Flyway getFlyway() {
        Flyway flyway = Flyway.configure()
                .dataSource(new DataSourceWithServiceProvider(sql.getDataSource(), injectionManager::getInstance))
                .table("schema_version")
                .locations(getLocations())
                .baselineVersion("69")
                .load();
        return flyway;
    }

    private String[] getLocations() {
        return List.of(
                LabMigrations.class.getPackage().getName(),
                "db/migration"
        ).toArray(new String[]{});
    }

}
