package ru.yandex.crypta.api.rest.resource.dmp;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import ru.yandex.crypta.clients.utils.Caching;
import ru.yandex.crypta.common.ws.jersey.JsonUtf8;
import ru.yandex.crypta.service.dmp.DmpService;


@Path("dmp")
@Api(tags = {"dmp"})
@Produces(JsonUtf8.MEDIA_TYPE)
@Singleton
public class DmpResource {
    private final DmpService dmp;

    @Inject
    public DmpResource(DmpService dmp) {
        this.dmp = dmp;
    }

    @GET
    @Path("index")
    @ApiOperation(value = "Gets DMP names")
    public Object getIndex() {
        return dmp.getIndexCached();
    }

    @GET
    @Path("meta/{dmp_login}")
    @ApiOperation(value = "Gets DMP description")
    public Object getMeta(@PathParam("dmp_login") String dmpLogin) {
        return Caching.fetchLoading(dmp.getMetaCache(), dmpLogin);
    }
}
