package ru.yandex.crypta.api.rest.resource.ext.cdp;

import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

import ru.yandex.crypta.api.ext.proto.TCdpDescriptionResponse;
import ru.yandex.crypta.api.rest.resource.lab.CommonLabResource;
import ru.yandex.crypta.common.exception.Exceptions;
import ru.yandex.crypta.common.ws.jersey.JsonUtf8;
import ru.yandex.crypta.lab.LabService;
import ru.yandex.crypta.lib.proto.identifiers.TIds;
import ru.yandex.crypta.siberia.proto.TDescribeIdsResponse;

@Produces(JsonUtf8.MEDIA_TYPE)
@Consumes(JsonUtf8.MEDIA_TYPE)
public class CdpResource extends CommonLabResource {
    @Inject
    public CdpResource(LabService lab) {
        super(lab);
    }

    @POST
    @Path("description")
    public TDescribeIdsResponse doDescribe(TIds request) {
        return lab().samples().describeIdsBySiberia(request);
    }

    @GET
    @Path("description/{id}")
    public TCdpDescriptionResponse getDescription(@PathParam("id") @NotNull String id) {
        var stats = lab().getStatsFromSiberia(id);
        if (stats.isEmpty()) {
            throw Exceptions.notFound();
        }
        var statsValue = stats.orElseThrow();
        return TCdpDescriptionResponse.newBuilder()
                .setStats(statsValue.getStats())
                .setInfo(statsValue.getInfo())
                .build();
    }
}
