package ru.yandex.crypta.api.rest.resource.ext.direct;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

import ru.yandex.crypta.api.ext.proto.TDirectCaDescriptionRequest;
import ru.yandex.crypta.api.ext.proto.TDirectCaDescriptionResponse;
import ru.yandex.crypta.api.rest.resource.lab.CommonLabResource;
import ru.yandex.crypta.common.exception.Exceptions;
import ru.yandex.crypta.common.ws.jersey.JsonUtf8;
import ru.yandex.crypta.lab.LabService;
import ru.yandex.crypta.lab.proto.TSimpleSampleStats;
import ru.yandex.crypta.siberia.bin.custom_audience.common.proto.TCaRule;

@Produces(JsonUtf8.MEDIA_TYPE)
@Consumes(JsonUtf8.MEDIA_TYPE)
public class DirectCaResource extends CommonLabResource {

    private static TDirectCaDescriptionResponse convertToDirectResponse(TSimpleSampleStats stats) {
        var responseBuilder = TDirectCaDescriptionResponse.newBuilder();

        var statsAffinities = stats.getAffinities();
        var affinitiesBuilder = responseBuilder.getAffinitiesBuilder();

        affinitiesBuilder.addAllBySegment(statsAffinities.getBySegmentList());
        affinitiesBuilder.addAllByHost(statsAffinities.getByHostList());
        affinitiesBuilder.addAllByWord(statsAffinities.getByWordList());
        affinitiesBuilder.addAllByAge(statsAffinities.getByAgeList());
        affinitiesBuilder.addAllByGender(statsAffinities.getByGenderList());
        affinitiesBuilder.addAllByIncome(statsAffinities.getByIncomeList());

        var countsBuilder = responseBuilder.getCountsBuilder();
        var statsCounts = stats.getCounts();

        countsBuilder.addAllByGender(statsCounts.getByGenderList());
        countsBuilder.addAllByAge(statsCounts.getByAgeList());
        countsBuilder.addAllByIncome(statsCounts.getByIncomeList());
        countsBuilder.addAllByDevice(statsCounts.getByDeviceList());
        countsBuilder.addAllByRegion(statsCounts.getByRegionList());
        countsBuilder.addAllByGenderAgeIncome(statsCounts.getByGenderAgeIncomeList());

        return responseBuilder.build();
    }

    private static TCaRule convertToGetStatsRequest(TDirectCaDescriptionRequest directRequest) {
        var builder = TCaRule.newBuilder();

        if (directRequest.hasGender()) {
            builder.setGender(directRequest.getGender());
        }

        builder.addAllAges(directRequest.getAgesList());
        builder.addAllDevices(directRequest.getDevicesList());
        builder.addAllRegions(directRequest.getRegionsList());
        builder.addAllIncomes(directRequest.getIncomesList());
        builder.addAllCountries(directRequest.getCountriesList());
        builder.addAllCities(directRequest.getCitiesList());
        builder.addAllSegments(directRequest.getSegmentsList());
        builder.addAllWords(directRequest.getWordsList());
        builder.addAllHosts(directRequest.getHostsList());
        builder.addAllAffinitiveSites(directRequest.getAffinitiveSitesList());
        builder.addAllTopCommonSites(directRequest.getTopCommonSitesList());

        return builder.build();
    }

    @Inject
    public DirectCaResource(LabService lab) {
        super(lab);
    }

    @POST
    @Path("description")
    public TDirectCaDescriptionResponse getCaDescription(TDirectCaDescriptionRequest request) {
        var stats = lab().getCustomAudienceStats(convertToGetStatsRequest(request));
        if (stats.isEmpty()) {
            throw Exceptions.internal("Failed to get stats from CA service");
        }
        return convertToDirectResponse(stats.orElseThrow());
    }
}
