package ru.yandex.crypta.api.rest.resource.ext.lilucrm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

public class LiluCrmGraph {

    private String cryptaId;
    private List<Node> nodes;
    private List<Edge> edges;

    public LiluCrmGraph(String cryptaId, List<Node> vertices, List<Edge> edges) {
        this.cryptaId = cryptaId;
        this.nodes = vertices;
        this.edges = edges;
    }

    @JsonProperty("crypta_id")
    public String getCryptaId() {
        return cryptaId;
    }

    public List<Node> getNodes() {
        return nodes;
    }

    public List<Edge> getEdges() {
        return edges;
    }

    public static class Node {

        private List<Object> values;

        public Node(String id, String idType) {
            this.values = List.of(idType, id, new HashMap());
        }

        @JsonValue
        public List<Object> getValues() {
            return values;
        }
    }

    public static class Edge {

        private List<Object> values;

        public Edge(int vertex1, int vertex2, Map<String, String> attributes) {
            this.values = List.of(vertex1, vertex2, attributes);
        }

        @JsonValue
        public List<Object> getValues() {
            return values;
        }
    }

}
