package ru.yandex.crypta.api.rest.resource.graph;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

import ru.yandex.crypta.common.exception.Exceptions;
import ru.yandex.crypta.graph.api.service.GraphService;
import ru.yandex.crypta.graph.api.service.SecureGraphService;
import ru.yandex.crypta.graph.api.service.SoupConfigGraphService;
import ru.yandex.crypta.graph.api.service.TransformerGraphService;
import ru.yandex.crypta.graph.api.service.VultureGraphService;
import ru.yandex.crypta.graph.api.service.YtAntifraudSoupGraphService;
import ru.yandex.crypta.graph.api.service.YtGraphEngineService;
import ru.yandex.crypta.graph.api.service.YtHouseholdsGraphService;
import ru.yandex.crypta.graph.api.service.YtHumanMatchingGraphService;
import ru.yandex.crypta.graph.api.service.YtProtoExportGraphService;
import ru.yandex.crypta.graph.api.service.YtRTGraphEngineService;
import ru.yandex.crypta.graph.api.service.YtSoupGraphService;
import ru.yandex.crypta.graph.api.service.YtSoupyIndeviceGraphService;
import ru.yandex.crypta.graph.api.service.YtV1GraphService;
import ru.yandex.crypta.lib.yt.YtService;

public class GraphServices {

    private final List<GraphService> graphServices;

    @Inject
    public GraphServices(YtHumanMatchingGraphService yt,
            YtProtoExportGraphService ytProtoExport,
            YtV1GraphService ytV1,
            YtHouseholdsGraphService households,
            YtSoupGraphService soup,
            YtAntifraudSoupGraphService antifraud,
            VultureGraphService vulture,
            SoupConfigGraphService soupConfig,
            YtSoupyIndeviceGraphService soupyIndeviceService,
            YtService ytService,
            YtGraphEngineService graphEngineService,
            YtRTGraphEngineService rtGraphEngineService,
            @Context SecurityContext securityContext)
    {

        this.graphServices = Stream.of(
                vulture,
                yt,
                ytProtoExport,
                soup,
                antifraud,
                soupyIndeviceService,
                households,
                ytV1,
                soupConfig,
                graphEngineService,
                rtGraphEngineService
        ).map(s ->
                new TransformerGraphService(new SecureGraphService(securityContext, s), ytService)
        ).collect(Collectors.toList());

    }

    public List<GraphService> getAll() {
        return graphServices;
    }

    public GraphService getByType(String matchingType) {
        Predicate<GraphService> isServingTheMatchingType = graphService ->
                graphService.getGraphSettings().isSupportedMatchType(matchingType);

        return graphServices
                .stream()
                .filter(isServingTheMatchingType)
                .findFirst()
                .orElseThrow(() -> Exceptions.illegal("matchingType is not supported: " + matchingType));
    }

}
