package ru.yandex.crypta.api.rest.resource.graph;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import ru.yandex.crypta.common.ws.jersey.JsonUtf8;
import ru.yandex.crypta.graph.api.service.GraphService;
import ru.yandex.crypta.graph.api.service.settings.GraphSettings;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeType;


@Api(tags = {"graph"})
@Produces(JsonUtf8.MEDIA_TYPE)
public class GraphSettingsResource {

    private final GraphServices graphServices;

    @Inject
    public GraphSettingsResource(GraphServices graphServices) {
        this.graphServices = graphServices;
    }

    @GET
    @Path("matchings")
    @ApiOperation(value = "Get all supported matchings")
    public List<String> getSupportedMatchTypes() {
        return graphServices.getAll()
                .stream()
                .map(GraphService::getGraphSettings)
                .map(GraphSettings::getSupportedMatchTypes)
                .flatMap(List::stream)
                .collect(Collectors.toList());
    }

    @GET
    @Path("matchings/{matchingType}")
    @ApiOperation(value = "Get match type config")
    public MatchTypeConfig getMatchTypeConfig(
            @PathParam("matchingType") String matchingType
    )
    {
        GraphSettings graphSettings = graphServices.getByType(matchingType).getGraphSettings();
        return new MatchTypeConfig(
                matchingType,
                graphSettings.getSupportedIdTypes(),
                graphSettings.getSupportedScopes()
        );
    }

    @GET
    @Path("edges")
    @ApiOperation(value = "Get supported edge types")
    public Collection<TEdgeType> getEdgeTypes() {
        return Soup.CONFIG.getEdgeTypes();
    }


}
