package ru.yandex.crypta.api.rest.resource.graph;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import ru.yandex.crypta.api.proto.TSocdemProfile;
import ru.yandex.crypta.common.exception.Exceptions;
import ru.yandex.crypta.common.ws.jersey.JsonUtf8;
import ru.yandex.crypta.graph.api.model.ids.GraphId;
import ru.yandex.crypta.graph.api.service.ids.IdsStorageService;

@Api(tags = {"graph"})
@Produces(JsonUtf8.MEDIA_TYPE)
public class IdsStorageResource {

    private IdsStorageService idsStorageService;

    @Inject
    public IdsStorageResource(IdsStorageService idsStorageService) {
        this.idsStorageService = idsStorageService;
    }

    @GET
    @Path("info")
    @ApiOperation(value = "Gets info about any identifier")
    public JsonNode getIdInfo(@QueryParam("id") String id,
            @QueryParam("idType") String idType)
    {
        return idsStorageService
                .getIdInfo(new GraphId(id, idType))
                .orElseThrow(Exceptions::notFound);
    }

    @GET
    @Path("yuid_all")
    @ApiOperation(value = "Gets additional info about yandexuid")
    public JsonNode getYuidAllInfo(@QueryParam("id") String id,
            @QueryParam("idType") String idType)
    {
        return idsStorageService
                .getYuidAllInfo(new GraphId(id, idType))
                .orElseThrow(Exceptions::notFound);
    }

    @GET
    @Path("aggregated_socdem")
    @ApiOperation(value = "Gets CryptaID aggregated socdem")
    public TSocdemProfile getAggregatedCryptaIdSocdem(@QueryParam("cryptaId") String cryptaId) {
        return idsStorageService
                .getAggregatedCryptaIdSocdem(cryptaId)
                .orElseThrow(Exceptions::notFound);
    }

    @GET
    @Path("graph_socdem")
    @ApiOperation(value = "Gets CryptaID socdem")
    public TSocdemProfile getGraphCryptaIdSocdem(
            @QueryParam("cryptaId") String cryptaId,
            @QueryParam("matchingType") String matchingType
    )
    {
        return idsStorageService
                .getGraphCryptaIdSocdem(cryptaId, matchingType)
                .orElseThrow(Exceptions::notFound);
    }

}
