package ru.yandex.crypta.api.rest.resource.idm.parameter;

import java.io.IOException;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.crypta.common.exception.Exceptions;
import ru.yandex.crypta.idm.Role;

public class RoleParameter {
    private final Role role;

    public RoleParameter(String raw) {
        try {
            role = new ObjectMapper().readValue(raw, Role.class);
        } catch (IOException e) {
            throw Exceptions.illegal("Wrong role: " + e.getMessage());
        }
    }

    public Role getRole() {
        return role;
    }
}
