package ru.yandex.crypta.api.rest.resource.idm.response;

public class SimpleResponse {

    private final int code;
    private final String warning;
    private final String error;
    private final String fatal;

    protected SimpleResponse(int code, String warning, String error, String fatal) {
        this.code = code;
        this.error = error;
        this.warning = warning;
        this.fatal = fatal;
    }

    public static SimpleResponse ok() {
        return new SimpleResponse(0, null, null, null);
    }

    public static SimpleResponse fatal(String message) {
        return new SimpleResponse(1, null, null, message);
    }

    public int getCode() {
        return code;
    }

    public String getWarning() {
        return warning;
    }

    public String getError() {
        return error;
    }

    public String getFatal() {
        return fatal;
    }
}
