package ru.yandex.crypta.api.rest.resource.lab;

import java.util.Map;

import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

import io.swagger.annotations.ApiOperation;

import ru.yandex.crypta.common.ws.jersey.JsonUtf8;
import ru.yandex.crypta.idm.Roles;
import ru.yandex.crypta.lab.Keyword;
import ru.yandex.crypta.lab.LabService;

@Produces(JsonUtf8.MEDIA_TYPE)
@Consumes(JsonUtf8.MEDIA_TYPE)
public class KeywordResource {

    private final LabService lab;

    @Inject
    public KeywordResource(LabService lab) {
        this.lab = lab;
    }

    @PUT
    @ApiOperation(value = "Put keyword info")
    @RolesAllowed({Roles.Lab.EXTENDED, Roles.Lab.ADMIN})
    public Keyword updateKeywordInfo(Keyword keyword) {
        return lab.updateKeywordInfo(keyword);
    }

    @GET
    @Path("{id}")
    @ApiOperation(value = "Retrieve keyword info")
    public Map<String, String> getKeywordInfo(@PathParam("id") String id) {
        return lab.getKeywordInfo(id);
    }

}
