package ru.yandex.crypta.api.rest.resource.lab;

import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.common.ws.jersey.JsonUtf8;
import ru.yandex.crypta.idm.Roles;
import ru.yandex.crypta.lab.LabService;
import ru.yandex.crypta.lab.proto.WholeView;
import ru.yandex.crypta.lib.mds.MdsService;

@Path("lab")
@Api(tags = {"lab"})
@Produces(JsonUtf8.MEDIA_TYPE)
@Consumes(JsonUtf8.MEDIA_TYPE)
public class LabResource {

    private static final Logger LOG = LoggerFactory.getLogger(LabResource.class);
    private final LabService lab;
    private final MdsService mds;

    @Inject
    public LabResource(LabService lab, MdsService mds) {
        this.lab = lab;
        this.mds = mds;
    }

    @GET
    @Path("check_access")
    @RolesAllowed({Roles.Lab.EXTENDED, Roles.Lab.ADMIN})
    public boolean checkAccess() {
        LOG.info("Check access");
        return true;
    }

    @PUT
    @Path("mds_folder")
    @RolesAllowed({Roles.Lab.EXTENDED, Roles.Lab.ADMIN})
    public void createFolder(String folder) {
        mds.createFolder(folder);
    }

    @GET
    @Path("all")
    @ApiOperation(value = "Get all data")
    public WholeView getAll(@QueryParam("lang") Language language) {
        return lab.withLanguage(Language.orDefault(language)).getAll();
    }

    @Path("audience")
    public Class<AudienceResource> audience() {
        return AudienceResource.class;
    }

    @Path("constructor")
    public Class<ConstructorResource> constructor() {
        return ConstructorResource.class;
    }

    @Path("socdem-thresholds")
    public Class<SocdemResource> socdem() {
        return SocdemResource.class;
    }

    @Path("keyword")
    public Class<KeywordResource> keyword() {
        return KeywordResource.class;
    }

    @Path("sample")
    public Class<SampleResource> sample() {
        return SampleResource.class;
    }

    @Path("training-sample")
    public Class<TrainingSampleResource> trainingSample() { return TrainingSampleResource.class; }

    @Path("model")
    public Class<ModelResource> model() {
        return ModelResource.class;
    }

    @Path("segment")
    public Class<SegmentResource> segment() {
        return SegmentResource.class;
    }

    @Path("segment/export")
    public Class<SegmentExportResource> segmentExport() {
        return SegmentExportResource.class;
    }

    @Path("site2vec")
    public Class<Site2VecResource> site2vec() {
        return Site2VecResource.class;
    }

    @Path("ext")
    public Class<ExtResource> ext() {
        return ExtResource.class;
    }

    @Path("utils")
    public Class<UtilsResource> utils() {
        return UtilsResource.class;
    }

}
