package ru.yandex.crypta.api.rest.resource.lab;

import java.util.List;

import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import io.swagger.annotations.ApiOperation;

import ru.yandex.crypta.common.ws.jersey.JsonUtf8;
import ru.yandex.crypta.lab.LabService;
import ru.yandex.crypta.lab.Site2VecService;

@Produces(JsonUtf8.MEDIA_TYPE)
@Consumes(JsonUtf8.MEDIA_TYPE)
public class Site2VecResource {

    private final LabService lab;

    @Inject
    public Site2VecResource(LabService lab) {
        this.lab = lab;
    }

    @GET
    @Path("yandexuid/{yandexuid}")
    @ApiOperation(value = "Get user vector")
    public Site2VecService.Vector getVectorByYandexuid(@PathParam("yandexuid") @NotNull String yandexuid) {
        return lab.site2vec().getVectorByYandexuid(yandexuid);
    }

    @GET
    @Path("host/{host}")
    @ApiOperation(value = "Get host vector")
    public Site2VecService.Vector getVectorByHost(@PathParam("host") @NotNull String host) {
        return lab.site2vec().getVectorByHost(host);
    }

    @GET
    @Path("cosines")
    @ApiOperation(value = "Get pairwise similarities")
    public List<Site2VecService.Similarity> computePairwiseSimilarities(
            @QueryParam("yandexuids") List<String> yandexuids, @QueryParam("hosts") List<String> hosts
    )
    {
        return lab.site2vec().computePairwiseSimilarities(yandexuids, hosts);
    }

}
