package ru.yandex.crypta.api.rest.resource.lab;

import java.util.Map;

import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import io.swagger.annotations.ApiOperation;

import ru.yandex.crypta.common.ws.jersey.JsonUtf8;
import ru.yandex.crypta.idm.Roles;
import ru.yandex.crypta.lab.LabService;
import ru.yandex.crypta.lab.proto.SocdemThreshold;

@Produces(JsonUtf8.MEDIA_TYPE)
@Consumes(JsonUtf8.MEDIA_TYPE)
public class SocdemResource {

    private final LabService lab;

    @Inject
    public SocdemResource(LabService lab) {
        this.lab = lab;
    }

    @GET
    @ApiOperation(value = "Retrieve probability thresholds for socdem segments")
    public Map<String, Map<String, Double>> getSocdemThresholds() {
        return lab.getSocdemThresholds();
    }

    @PUT
    @ApiOperation(value = "Retrieve probability thresholds for socdem segments")
    @RolesAllowed({Roles.Lab.EXTENDED, Roles.Lab.ADMIN})
    public SocdemThreshold updateSocdemThreshold(
            @QueryParam("socdem") @NotNull String socdem,
            @QueryParam("segment") @NotNull String segment,
            @QueryParam("threshold") @NotNull Double threshold
    )
    {
        return lab.updateSocdemThreshold(SocdemThreshold.newBuilder()
                .setSocdem(socdem)
                .setSegment(segment)
                .setThreshold(threshold)
                .build());
    }

}
