package ru.yandex.crypta.api.rest.resource.lab.grab;

import java.time.Instant;

import ru.yandex.crypta.api.rest.resource.portal.grab.GrabId;

public class AudienceGrab {
    private GrabId grabId;
    private Long timestamp;
    private Boolean auth;
    private String login;

    public AudienceGrab() {
    }

    public AudienceGrab(GrabId grabId, Long timestamp, Boolean auth, String login) {
        this.grabId = grabId;
        this.timestamp = timestamp;
        this.auth = auth;
        this.login = login;
    }

    public AudienceGrab withAuth(Boolean auth) {
        this.auth = auth;
        return this;
    }

    public GrabId getGrabId() {
        return grabId;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public Boolean getAuth() {
        return auth;
    }

    public String getLogin() {
        return login;
    }

    public boolean hasExpired(int secondsPassed) {
        long now = Instant.now().getEpochSecond();
        return now - timestamp > secondsPassed;
    }
}
