package ru.yandex.crypta.api.rest.resource.lab.grab;

import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.impl.DSL;

import ru.yandex.crypta.api.rest.resource.portal.grab.GrabId;
import ru.yandex.crypta.common.data.GenericTable;

public class AudienceGrabTable extends GenericTable<AudienceGrab> {
    private static final String TABLE_NAME = "audience_grab";
    private static final Table<Record> TABLE = DSL.table(TABLE_NAME);
    private static final Field<String> GRAB_ID = DSL.field("grab_id", String.class);
    private static final Field<Long> TIMESTAMP = DSL.field("timestamp", Long.class);
    private static final Field<Boolean> AUTH = DSL.field("auth", Boolean.class);
    private static final Field<String> LOGIN = DSL.field("login", String.class);

    public AudienceGrabTable(Configuration configuration) {
        super(configuration, AudienceGrab.class);
    }

    @Override
    protected AudienceGrab read(Record record) {
        GrabId grabId = new GrabId(record.get(GRAB_ID));
        Long timestamp = record.get(TIMESTAMP);
        boolean auth = record.get(AUTH);
        String login = record.get(LOGIN);
        return new AudienceGrab(grabId, timestamp, auth, login);
    }

    public Select<Record> selectByIdQuery(String grabId) {
        return dsl.selectFrom(TABLE).where(GRAB_ID.equal(grabId));
    }

    public Query upsertQuery(AudienceGrab grab) {
        return dsl.insertInto(TABLE)
                .set(GRAB_ID, grab.getGrabId().getValue())
                .set(TIMESTAMP, grab.getTimestamp())
                .set(AUTH, grab.getAuth())
                .set(LOGIN, grab.getLogin())
                .onConflict(GRAB_ID)
                .doUpdate()
                .set(AUTH, grab.getAuth());
    }

    @Override
    public Select selectQuery() {
        return dsl.selectFrom(TABLE);
    }
}
