package ru.yandex.crypta.api.rest.resource.other;

import java.util.Objects;

import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

import NGetoptPb.Confoption;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import io.swagger.annotations.Api;

import ru.yandex.crypta.api.proto.TApiServerConfig;
import ru.yandex.crypta.common.ws.jersey.JsonUtf8;
import ru.yandex.crypta.idm.Roles;
import ru.yandex.crypta.lib.proto.Extensions;

@Path("config")
@Produces(JsonUtf8.MEDIA_TYPE)
@RolesAllowed(Roles.ADMIN)
@Api(hidden = true)
public class ConfigResource {

    public static final String SECRET = "<secret>";
    @Inject
    private TApiServerConfig config;

    @GET
    public TApiServerConfig getConfig() {
        return mask(config);
    }

    @SuppressWarnings("unchecked")
    private <T extends Message> T mask(T message) {
        Message.Builder masked = message.toBuilder().clone();
        maskMessage(masked);
        return (T) masked.build();
    }

    private void maskMessage(Message.Builder builder) {
        for (var field : builder.getDescriptorForType().getFields()) {
            if (Objects.equals(field.getType(), Descriptors.FieldDescriptor.Type.MESSAGE)) {
                maskMessage(builder.getFieldBuilder(field));
            }
            if (Objects.equals(field.getType(), Descriptors.FieldDescriptor.Type.STRING)) {
                var confExtension = field.getOptions().getExtension(Confoption.conf);
                if (Objects.nonNull(confExtension) && confExtension.hasIgnore()) {
                    builder.setField(field, SECRET);
                }

                var isSecretExtension = field.getOptions().getExtension(Extensions.isSecret);
                if (Objects.nonNull(isSecretExtension) && isSecretExtension) {
                    builder.setField(field, SECRET);
                }
            }
        }
    }

}
