package ru.yandex.crypta.api.rest.resource.other;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

import io.swagger.annotations.Api;

import ru.yandex.crypta.common.ws.jersey.JsonUtf8;
import ru.yandex.crypta.graph.Identifier;

@Api(tags = "identifier")
@Path("identifier")
@Produces(JsonUtf8.MEDIA_TYPE)
public class IdentifierResource {

    @GET
    @Path("{type}/{value}")
    public CheckResult checkIdentifier(
            @PathParam("type") String type,
            @PathParam("value") String value
    )
    {
        Identifier identifier = new Identifier(type, value);
        return new CheckResult(type, identifier.isValid(), identifier.getNormalizedValue(),
                identifier.getMd5(), identifier.getSha256());
    }

    public static class CheckResult {

        private final String type;
        private final boolean valid;
        private final String normalized;
        private final String md5;
        private final String sha256;

        public CheckResult(String type, boolean valid, String normalized, String md5, String sha256) {
            this.type = type;
            this.valid = valid;
            this.normalized = normalized;
            this.md5 = md5;
            this.sha256 = sha256;
        }

        public String getType() {
            return type;
        }

        public boolean isValid() {
            return valid;
        }

        public String getNormalized() {
            return normalized;
        }

        public String getMd5() {
            return md5;
        }

        public String getSha256() {
            return sha256;
        }

    }

}
