package ru.yandex.crypta.api.rest.resource.other;

import java.util.Optional;

import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import io.swagger.annotations.Api;

import ru.yandex.crypta.clients.graphite.GraphiteClient;
import ru.yandex.crypta.common.ws.jersey.JsonUtf8;
import ru.yandex.crypta.common.ws.solomon.Solomon;
import ru.yandex.monlib.metrics.primitives.Rate;

@Api(tags = "metric")
@Path("metric")
@Produces(JsonUtf8.MEDIA_TYPE)
public class MetricResource {

    private final GraphiteClient graphite;

    private static final Rate METRIC_RATE = Solomon.REGISTRY.rate("graphite.total");

    @Inject
    public MetricResource(GraphiteClient graphite) {
        this.graphite = graphite;
    }

    @POST
    @Path("report")
    public GraphiteClient.GraphiteResponse report(
            @QueryParam("frequency") GraphiteClient.Frequency frequency,
            @QueryParam("hostname") @NotNull String hostname,
            @QueryParam("group") @NotNull String group,
            @QueryParam("name") @NotNull String name,
            @QueryParam("timestamp") @NotNull Long timestamp,
            @QueryParam("value") @NotNull Double value
    )
    {
        METRIC_RATE.inc();
        GraphiteClient.Frequency actualFrequency = Optional.ofNullable(frequency)
                .orElse(GraphiteClient.Frequency.ONE_MIN);
        GraphiteClient.FullName fullName = new GraphiteClient.FullName(actualFrequency, hostname, group, name);
        return graphite.report(fullName, new GraphiteClient.Timestamp(timestamp), new GraphiteClient.Value(value));
    }

}
