package ru.yandex.crypta.api.rest.resource.portal;


import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

import io.swagger.annotations.Api;

import ru.yandex.crypta.api.rest.resource.portal.grab.GrabResource;
import ru.yandex.crypta.common.ws.jersey.JsonUtf8;

@Path("portal")
@Api(tags = {"portal"})
@Produces(JsonUtf8.MEDIA_TYPE)
@Consumes(JsonUtf8.MEDIA_TYPE)
public class PortalResource {

    @Path("geo")
    public Class<GeoResource> geo() {
        return GeoResource.class;
    }

    @Path("grab")
    public Class<GrabResource> grab() {
        return GrabResource.class;
    }

    @Path("me")
    public Class<MeResource> me() { return MeResource.class; }

    @Path("public_portal")
    public Class<PublicPortalResource> publicPortal() { return PublicPortalResource.class; }

    @Path("settings")
    public Class<PortalSettingsResource> settings() {
        return PortalSettingsResource.class;
    }

}
