package ru.yandex.crypta.api.rest.resource.portal.grab;

import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.impl.DSL;

import ru.yandex.crypta.common.data.GenericTable;

public class GrabTable extends GenericTable<Grab> {

    private static final String TABLE_NAME = "portal_grab";
    private static final Table<Record> TABLE = DSL.table(TABLE_NAME);
    private static final Field<String> GRAB_ID = DSL.field("grab_id", String.class);
    private static final Field<String> LOGIN = DSL.field("login", String.class);
    private static final Field<String> USERAGENT = DSL.field("useragent", String.class);
    private static final Field<String> YANDEXUID = DSL.field("yandexuid", String.class);
    private static final Field<Long> TIMESTAMP = DSL.field("timestamp", Long.class);

    public GrabTable(Configuration configuration) {
        super(configuration, Grab.class);
    }

    @Override
    protected Grab read(Record record) {
        GrabId grabId = new GrabId(record.get(GRAB_ID));
        String login = record.get(LOGIN);
        String useragent = record.get(USERAGENT);
        String yandexuid = record.get(YANDEXUID);
        Long timestamp = record.get(TIMESTAMP);
        return new Grab(grabId, login, useragent, yandexuid, timestamp);
    }

    public Select<Record> selectByIdQuery(String grabId) {
        return dsl.selectFrom(TABLE).where(GRAB_ID.equal(grabId));
    }

    public Query upsertQuery(Grab grab) {
        return dsl.insertInto(TABLE)
                .set(GRAB_ID, grab.getGrabId().getValue())
                .set(LOGIN, grab.getLogin())
                .set(USERAGENT, grab.getUseragent())
                .set(YANDEXUID, grab.getYandexuid())
                .set(TIMESTAMP, grab.getTimestamp())
                .onConflict(GRAB_ID)
                .doUpdate()
                .set(LOGIN, grab.getLogin())
                .set(USERAGENT, grab.getUseragent())
                .set(YANDEXUID, grab.getYandexuid())
                .set(TIMESTAMP, grab.getTimestamp());
    }

    @Override
    public Select selectQuery() {
        return dsl.selectFrom(TABLE);
    }
}
