package ru.yandex.crypta.api.rest.resource.tx;

import java.util.List;

import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import NCrypta.Transaction;
import NCrypta.TransactionSource.ETransactionSource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;

import ru.yandex.crypta.clients.bigb.BigbIdType;
import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.common.ws.jersey.JsonUtf8;
import ru.yandex.crypta.idm.Roles;
import ru.yandex.crypta.service.tx.TxService;

@Path("tx")
@Api(tags = {"tx"})
@Produces(JsonUtf8.MEDIA_TYPE)
@Consumes(JsonUtf8.MEDIA_TYPE)
public class TxResource {
    private final TxService txService;

    @Inject
    TxResource(TxService txService) {
        this.txService = txService;
    }

    @QueryParam("lang")
    @ApiParam(value = "Language")
    @SuppressWarnings("UnusedVariable")
    private Language language;

    @GET
    @Path("get_via_bb")
    @RolesAllowed({Roles.Portal.TX})
    public List<Transaction.TTransaction> getViaBB(
            @QueryParam("source") @ApiParam(value = "Source of transactions") @NotNull ETransactionSource txSource,
            @QueryParam("uidType") @ApiParam(value = "BigB uid type") @NotNull BigbIdType bigbIdType,
            @QueryParam("uid") @ApiParam(value = "BigB uid value") @NotNull String bigbIdValue
    ) {
        return txService.getTransactions(txSource, bigbIdType, bigbIdValue);
    }

    @GET
    @Path("get_all_via_bb")
    @RolesAllowed({Roles.Portal.TX})
    public List<Transaction.TTransaction> getAllViaBB(
            @QueryParam("uidType") @ApiParam(value = "BigB uid type") @NotNull BigbIdType bigbIdType,
            @QueryParam("uid") @ApiParam(value = "BigB uid value") @NotNull String bigbIdValue
    ) {
        return txService.getAllTransactions(bigbIdType, bigbIdValue);
    }
}
