package ru.yandex.crypta.api.tools;

import org.quartz.Job;
import org.quartz.SimpleScheduleBuilder;

import ru.yandex.crypta.api.Main;
import ru.yandex.crypta.api.config.Scheduling;
import ru.yandex.crypta.lib.schedulers.Schedulers;

public class ExecuteTaskMain extends Main {

    protected ExecuteTaskMain(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        var main = new ExecuteTaskMain(args);
        main.startServer();
        try {
            var serviceProvider = main.getServiceProvider();
            Class<? extends Job> taskClass = getTask();
            var schedulers = serviceProvider.get(Schedulers.class);
            var schedule = SimpleScheduleBuilder.simpleSchedule();
            var quartz = schedulers.getQuartz().get();
            Scheduling.scheduleSimpleJob(main.config, quartz, taskClass, schedule);
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @SuppressWarnings("")
    private static Class<? extends Job> getTask() throws ClassNotFoundException {
        return (Class<? extends Job>) Class.forName(System.getenv("TASK"));
    }

}
