create table if not exists api_segments(
  "id" varchar(80) not null,
  "name" varchar(100000) not null,
  "name_en" varchar(100000) not null,
  "name_ru" varchar(100000) not null,
  "description" varchar(100000) not null,
  "description_en" varchar(100000) not null,
  "description_ru" varchar(100000) not null,
  "priority" bigint null default 0,
  "ticket" varchar(50) not null,
  "state" varchar(50) null,
  "type" varchar(50) not null,
  "scope" varchar(50) not null,
  "created" bigint not null,
  "modified" bigint not null,
  "parent_id" varchar(80) null,
  constraint "PK_SEGMENT"
    primary key ("id"),
  constraint "FK_PARENT_ID"
    foreign key ("parent_id")
    references api_segments ("id")
);
create table if not exists api_segments_history(
  "id" varchar(80) not null,
  "name" varchar(100000) not null,
  "name_en" varchar(100000) not null,
  "name_ru" varchar(100000) not null,
  "description" varchar(100000) not null,
  "description_en" varchar(100000) not null,
  "description_ru" varchar(100000) not null,
  "priority" bigint null default 0,
  "ticket" varchar(50) not null,
  "state" varchar(50) null,
  "type" varchar(50) not null,
  "scope" varchar(50) not null,
  "created" bigint not null,
  "modified" bigint not null,
  "parent_id" varchar(80) null
);
create table if not exists audience_grab(
  grab_id varchar(1000) not null,
  timestamp bigint not null,
  auth boolean not null,
  login varchar(80) not null,
  constraint "PK_GRAB_ID"
    primary key (grab_id)
);
create table if not exists api_audiences(
  "id" varchar(80) not null,
  "author" varchar(100000) not null,
  "name" varchar(100000) not null,
  "purpose" varchar(100000) not null,
  "login" varchar(100000) not null,
  "external_id" bigint null default 0,
  "source_path" varchar(100000) not null,
  "source_field" varchar(100000) not null,
  "state" varchar(50) null,
  "created" bigint not null,
  "modified" bigint not null,
  constraint "PK_AUDIENCES"
    primary key ("id")
);
create table if not exists api_audiences_history(
  "id" varchar(80) not null,
  "author" varchar(100000) not null,
  "name" varchar(100000) not null,
  "purpose" varchar(100000) not null,
  "login" varchar(100000) not null,
  "external_id" bigint null default 0,
  "source_path" varchar(100000) not null,
  "source_field" varchar(100000) not null,
  "state" varchar(50) null,
  "created" bigint not null,
  "modified" bigint not null
);
create table if not exists portal_grab(
  grab_id varchar(1000) not null,
  login varchar(80) not null,
  useragent varchar(100000) not null,
  yandexuid varchar(20) not null,
  timestamp bigint not null,
  constraint "PK_GRAB_ID"
    primary key (grab_id)
);
create table if not exists api_keywords(
  "id" varchar(256) not null,
  "segment" varchar(65536) not null,
  constraint "pk_keywords"
    primary key ("id")
);
create table if not exists api_model_segment_relations(
  "model_id" varchar(80) not null,
  "segment_id" varchar(80) not null,
  "low_threshold" double precision null,
  "high_threshold" double precision null,
  "created" bigint not null,
  "modified" bigint not null,
  constraint "PK_MODEL_SEGMENT_RELATIONS"
    primary key (
      "model_id",
      "segment_id"
    ),
  constraint "FK_MODELS"
    foreign key ("model_id")
    references api_models ("id"),
  constraint "FK_SEGMENTS"
    foreign key ("segment_id")
    references api_segments ("id")
);
create table if not exists api_model_segment_relations_history(
  "model_id" varchar(80) not null,
  "segment_id" varchar(80) not null,
  "low_threshold" double precision null,
  "high_threshold" double precision null,
  "created" bigint not null,
  "modified" bigint not null
);
create table if not exists api_models(
  "id" varchar(80) not null,
  "description" varchar(10000) null,
  "uri" varchar(1000) not null,
  "s3_uri" varchar(300) null,
  "tag" varchar(50) null,
  "state" varchar(50) not null,
  "created" bigint not null,
  "modified" bigint not null,
  constraint "PK_MODEL"
    primary key ("id")
);
create table if not exists api_models_history(
  "id" varchar(80) not null,
  "description" varchar(10000) null,
  "uri" varchar(1000) not null,
  "s3_uri" varchar(300) null,
  "tag" varchar(50) null,
  "state" varchar(50) not null,
  "created" bigint not null,
  "modified" bigint not null
);
create table if not exists api_responsibles(
  "id" varchar(80) not null,
  "segment_id" varchar null,
  "created" bigint not null,
  "modified" bigint not null,
  constraint "PK_RESPONSIBLES"
    primary key (
      "id",
      "segment_id"
    ),
  constraint "FK_RESPONSIBLES_SEGMENTS"
    foreign key ("segment_id")
    references api_segments ("id")
);
create table if not exists api_responsibles_history(
  "id" varchar(80) not null,
  "segment_id" varchar null,
  "created" bigint not null,
  "modified" bigint not null
);
create table if not exists api_lab_samples(
  "id" varchar(80) not null,
  "author" varchar(80) not null,
  "access_level" varchar(80) not null,
  "name" varchar(256) null,
  "id_type" varchar(80) not null,
  "id_key" varchar(80) not null,
  "grouping_key" varchar(256) null,
  "modified" bigint not null,
  "created" bigint not null,
  "ttl" bigint null,
  "type" varchar(80) not null,
  "cdp_id" varchar(40) null,
  constraint "PK_LAB_SAMPLES"
    primary key ("id")
);
create table if not exists api_lab_sample_views(
  "sample_id" varchar(80) not null,
  "id" varchar(80) not null,
  "path" varchar(1000) not null,
  "state" varchar(80) not null,
  "options" bytea null,
  primary key (
    "sample_id",
    "id"
  ),
  foreign key ("sample_id")
  references api_lab_samples ("id")
);
create table if not exists api_stakeholders(
  "id" varchar(80) not null,
  "segment_id" varchar null,
  "created" bigint not null,
  "modified" bigint not null,
  constraint "PK_STAKEHOLDERS"
    primary key (
      "id",
      "segment_id"
    ),
  constraint "FK_STAKEHOLDERS_SEGMENTS"
    foreign key ("segment_id")
    references api_segments ("id")
);
create table if not exists api_stakeholders_history(
  "id" varchar(80) not null,
  "segment_id" varchar null,
  "created" bigint not null,
  "modified" bigint not null
);
create table if not exists api_segment_exports(
  "segment_id" varchar(80) not null,
  "id" varchar(80) not null,
  "type" varchar(80) not null,
  "state" varchar(80) not null,
  "export_keyword_id" bigint not null,
  "export_segment_id" bigint not null,
  "coverage_profiles_value" bigint null,
  "coverage_profiles_timestamp" bigint null,
  "coverage_bigb_value" bigint null,
  "coverage_bigb_timestamp" bigint null,
  "link_export_id" varchar(80) null,
  "link_type" varchar(50) null,
  "link_value" varchar(50) null,
  "rule_id" varchar(80) not null,
  constraint "api_segment_exports_pkey"
    primary key ("id"),
  constraint "api_segment_exports_segment_id_fkey"
    foreign key ("segment_id")
    references api_segments ("id"),
  constraint "api_segment_exports_link_export_id_fkey"
    foreign key ("link_export_id")
    references api_segment_exports ("id"),
  constraint "api_segment_exports_rulet_id_fkey"
    foreign key ("rule_id")
    references api_constructor_rules ("id"),
  constraint "api_segment_exports_export_ids_unique"
    unique (
      "export_keyword_id",
      "export_segment_id"
    )
);
create table if not exists api_socdem_thresholds(
  "socdem" varchar(256) not null,
  "segment" varchar(256) not null,
  "threshold" double precision not null,
  constraint "pk_socdem_thresholds"
    primary key (
      "socdem",
      "segment"
    )
);