CREATE TABLE IF NOT EXISTS lab_training_samples(
    "id" VARCHAR(32) NOT NULL,
    "name" VARCHAR(256),
    "author" VARCHAR(32) NOT NULL,
    "access_level" VARCHAR(32) NOT NULL,
    "ttl" BIGINT,
    "created" BIGINT NOT NULL,
    "modified" BIGINT NOT NULL,
    CONSTRAINT "PK_LAB_TRAINING_SAMPLES"
        PRIMARY KEY ("id")
);

CREATE TABLE IF NOT EXISTS lab_training_sample_user_set_ids (
    "sample_id" VARCHAR(32) NOT NULL,
    "user_set_id" VARCHAR(32) NOT NULL,
    "target_type" VARCHAR(32) NOT NULL,
    "origin_type" VARCHAR(32) NOT NULL,
    "segment_size" INTEGER,
    CONSTRAINT "PK_LAB_TRAINING_SAMPLE_USER_SET_IDS"
        PRIMARY KEY ("sample_id", "user_set_id"),
    CONSTRAINT "lab_training_sample_user_set_ids_fk"
        FOREIGN KEY ("sample_id")
            REFERENCES lab_training_samples("id")
            ON DELETE CASCADE
);

CREATE TABLE IF NOT EXISTS lab_training_sample_metrics (
    "sample_id" VARCHAR(32) NOT NULL,
    "roc_auc" DOUBLE PRECISION,
    "accuracy" DOUBLE PRECISION,
    "positive_class_ratio" DOUBLE PRECISION,
    "train_sample_size" INTEGER,
    "matched_ids_ratio" DOUBLE PRECISION,
    "top_features" TEXT,
    CONSTRAINT "PK_LAB_TRAINING_SAMPLE_METRICS"
        PRIMARY KEY ("sample_id"),
    CONSTRAINT "lab_training_sample_metrics_fk"
        FOREIGN KEY ("sample_id")
            REFERENCES lab_training_samples("id")
            ON DELETE CASCADE
);
