from util.generic.map cimport TMap
from util.generic.string cimport TString
from util.generic.vector cimport TVector
from libc.stdint cimport uint64_t

cdef extern from "crypta/lib/proto/user_data/user_data.pb.h" namespace "NLab" nogil:
    cdef cppclass TSegment:
        uint64_t GetKeyword() const
        uint64_t GetID() const

        void SetKeyword(uint64_t value)
        void SetID(uint64_t value)


cdef extern from "crypta/lib/proto/user_data/user_data_stats.pb.h" namespace "NLab" nogil:
    cdef cppclass TUserDataStats:
        bint ParseFromString(const TString& data)


cdef extern from "crypta/audience/lib/affinity/affinity.h" nogil:
    TMap[TSegment, double] ComputeAffinities(const TVector[TSegment]& targetSegments, const TUserDataStats& localStats, const TUserDataStats& globalStats)


def _compute_affinities(target_segments, local_stats, global_stats):
    cdef TVector[TSegment] targetSegments
    cdef TUserDataStats localStats
    cdef TUserDataStats globalStats
    cdef TSegment segment

    localStats.ParseFromString(local_stats.SerializeToString())
    globalStats.ParseFromString(global_stats.SerializeToString())

    for each in target_segments:
        segment.SetID(each.ID)
        segment.SetKeyword(each.Keyword)
        targetSegments.push_back(segment)

    cdef TMap[TSegment, double] result = ComputeAffinities(targetSegments, localStats, globalStats)

    return {"{}/{}".format(pair.first.GetKeyword(), pair.first.GetID()): pair.second for pair in result}
