import bisect
import numpy as np


class Quantiles(object):
    """ All these quantiles were computed with the use of SCIENCE,
    yet should be replaced with something sane indeed."""

    COSINE = [
        0.91,
        0.92,
        0.93,
        0.94,
        0.95,
        0.96,
        0.97,
        0.98,
        0.99,
        0.995,
    ]


def _get_mean2(statistic):
    vector = np.array(statistic.Mean2.Data)
    vector /= statistic.Count
    return vector


def _get_mean(statistic):
    vector = np.array(statistic.Mean.Data)
    vector /= statistic.Count
    return vector


def _get_mean_and_mean2(statistic):
    return _get_mean(statistic), _get_mean2(statistic)


def _raw_trace(stats):
    trace = stats.Distributions.Precomputed.Trace
    if trace:
        return trace
    mean, mean2 = _get_mean_and_mean2(stats.Distributions.Main)
    if not mean2.size:
        return 0.
    trace = np.sum(mean2 - mean*mean)
    assert trace >= -1e-7, "trace must be not negative {}\nmean2={}\nmean**2={}".format(trace, mean2, mean*mean)
    return trace


def _quantile_score(raw, quantiles):
    return min(max(bisect.bisect_left(quantiles, raw) + 1, 1), 10)


def _cosine_quantile_score(raw):
    return _quantile_score(raw, Quantiles.COSINE)


def _compute_communality(local_stats, segment_type, all_quantiles):
    local_trace = _raw_trace(local_stats)
    quantiles = all_quantiles.get(segment_type) if all_quantiles is not None else None
    if quantiles is None:
        return 5
    return _quantile_score(local_trace, quantiles)
