from crypta.audience.lib.tasks.base import YQLTaskV1 as YQLTask

from crypta.lib.python.bt.workflow import (
    IndependentTask,
    Parameter
)
from crypta.lib.python import (
    templater,
)
from crypta.lab.lib.tables import (
    UserData,
)
from crypta.lib.python.bt.workflow.targets.table import (
    HasAttribute,
)

import library.python.resource as rs
import crypta.lib.python.bt.commons.dates as dates
import crypta.lib.python.bt.conf.conf as conf
import time

import logging
logger = logging.getLogger(__name__)


class PrepareBase(YQLTask, IndependentTask):
    day = Parameter(parse=dates.parse_day)

    @property
    def last_update_date(self):
        return str(self.day)

    @property
    def target_path(self):
        raise NotImplementedError

    def targets(self):
        yield HasAttribute(
            self.yt, self.target_path,
            UserData.Attributes.LAST_UPDATE_DATE, self.last_update_date
        )

    def run(self, **kwargs):
        super(PrepareBase, self).run(**kwargs)
        self.yt.set_attribute(self.target_path, UserData.Attributes.LAST_UPDATE_DATE, self.last_update_date)


class Prepare(PrepareBase):
    @property
    def target_path(self):
        return conf.paths.audience.matching.by_id_value

    @property
    def query(self):
        cryptaid_paths = conf.paths.audience.matching.cryptaid
        return rs.find('/query/matching.yql').format(
            vertices=conf.paths.audience.vertices,
            cryptaid_phones=cryptaid_paths.phones,
            cryptaid_emails=cryptaid_paths.emails,
            cryptaid_devids=cryptaid_paths.devids,
            cryptaid_yandexuids=cryptaid_paths.yandexuids,
            cryptaid_macs=cryptaid_paths.macs,
            by_id_value=conf.paths.audience.matching.by_id_value,
            profiles=conf.paths.crypta.profiles_for_14days,
            device_hashes=conf.paths.audience.matching.device_hashes,
            rtb_log_start=str(dates.day_back(self.day, conf.proto.Options.Matching.RtbLogDaysBack)),
            rtb_log_end=str(self.day),
            now=int(time.time()),
        )


class PrepareCryptaIds(PrepareBase):
    @property
    def target_path(self):
        return conf.paths.audience.matching.cryptaids

    @property
    def query(self):
        return templater.render_resource('/query/prepare_crypta_ids.yql', vars={
            "cryptaid_profiles": conf.paths.crypta.cryptaid_profiles_for_14days,
            "cryptaids": self.target_path,
        })
