#include <crypta/audience/lib/native/audience.h>

using namespace NYT;
using namespace NAudience;

void TBatchify::Do(TTableReader<TInput>* input, TTableWriter<TInputBatch>* output) {
    for (; input->IsValid(); input->Next()) {
        auto out = TInputBatch();
        auto idValue = input->GetRow().GetIdValue();
        idValue.to_lower();

        out.SetIdValue(idValue);
        out.SetSegmentID(State->GetMapping().at(input->GetTableIndex()));
        output->AddRow(out);
    }
}

void TKeepUniqueStorageOutput::Do(TTableReader<TStorageOutput>* input, TTableWriter<TStorageOutput>* output) {
    for (; input->IsValid(); input->Next()) {
        output->AddRow(input->GetRow());
        break;
    }
}

void TExtractStorageOutput::Do(TTableReader<TOutputBatch>* input, TTableWriter<TStorageOutput>* output) {
    auto excludedSegments = State->GetExcludedSegments();
    for (; input->IsValid(); input->Next()) {
        const auto& in = input->GetRow();
        TStorageOutput out;
        auto externalID = in.GetExternalID();
        if (excludedSegments.count(externalID) > 0) {
            continue;
        }
        out.SetYandexuid(in.GetYandexuid());
        out.SetExternalID(in.GetExternalID());
        out.SetTimestamp(State->GetTimestamp());
        output->AddRow(out);
    }
}

void TExtractGeneralStorageOutput::Do(TTableReader<TInputBatch>* input, TTableWriter<TGeneralStorageOutput>* output) {
    auto segments = State->GetSegments();
    for (; input->IsValid(); input->Next()) {
        const auto& in = input->GetRow();

        TString segmentId = in.GetSegmentID();
        if (segments.count(segmentId)) {
            TGeneralStorageOutput out;
            auto& segment = segments[segmentId];

            out.SetHash(in.GetIdValue());
            out.SetSegmentID(segment.GetSegmentID());

            out.SetTimestamp(State->GetTimestamp());
            out.SetIdType(segment.GetIdType());
            out.SetSegmentType(segment.GetSegmentType());

            output->AddRow(out, segment.GetTableIndex());
        }
    }
}
