#pragma once

#include <util/string/cast.h>
#include <util/generic/map.h>
#include <crypta/lib/python/native_yt/cpp/registrar.h>
#include <crypta/lib/python/native_yt/cpp/proto.h>
#include <mapreduce/library/io/proto/proto.h>
#include <crypta/audience/proto/other.pb.h>
#include <crypta/audience/proto/states.pb.h>
#include <crypta/audience/proto/tables.pb.h>
#include <crypta/lib/native/state/common.h>

#include <library/cpp/yson/node/node_io.h>
#include <iostream>

using namespace NYT;
using namespace NAudience;

class TBatchify: public IMapper<TTableReader<TInput>, TTableWriter<TInputBatch>> {
public:
    TBatchify()
        : State()
    {
    }
    TBatchify(const TBuffer& buffer)
        : State(buffer)
    {
    }

    void Do(TTableReader<TInput>* input, TTableWriter<TInputBatch>* output) override;

    void Save(IOutputStream& output) const override {
        State.Save(output);
    }
    void Load(IInputStream& input) override {
        State.Load(input);
    }

private:
    NNativeYT::TProtoState<TMapping> State;
};

class TExtractStorageOutput: public IMapper<TTableReader<TOutputBatch>, TTableWriter<TStorageOutput>> {
public:
    TExtractStorageOutput()
        : State()
    {
    }
    TExtractStorageOutput(const TBuffer& buffer)
        : State(buffer)
    {
    }

    void Do(TTableReader<TOutputBatch>* input, TTableWriter<TStorageOutput>* output) override;

    void Save(IOutputStream& output) const override {
        State.Save(output);
    }
    void Load(IInputStream& input) override {
        State.Load(input);
    }

private:
    NNativeYT::TProtoState<TExportToStorageState> State;
};

class TKeepUniqueStorageOutput: public IReducer<TTableReader<TStorageOutput>, TTableWriter<TStorageOutput>> {
public:
    void Do(TTableReader<TStorageOutput>* input, TTableWriter<TStorageOutput>* output) override;
};

class TExtractGeneralStorageOutput: public  TStateful<TGeneralStorageState, IMapper<TTableReader<TInputBatch>, TTableWriter<TGeneralStorageOutput>>> {
public:
    TExtractGeneralStorageOutput() : TStateful() {}
    TExtractGeneralStorageOutput(const TBuffer& buffer) : TStateful(buffer) {}

    void Do(TTableReader<TInputBatch>* input, TTableWriter<TGeneralStorageOutput>* output) override;
};

