#pragma once

#include <crypta/audience/proto/audience_geo.pb.h>
#include <crypta/audience/proto/other.pb.h>
#include <crypta/audience/proto/states.pb.h>
#include <crypta/audience/proto/tables.pb.h>
#include <crypta/lab/lib/native/segments_user_data_stats_aggregator.h>
#include <crypta/lab/proto/other.pb.h>
#include <crypta/lib/native/state/common.h>
#include <crypta/lib/proto/user_data/user_data_stats.pb.h>
#include <crypta/lib/proto/user_data/math.pb.h>
#include <crypta/lib/python/native_yt/cpp/registrar.h>
#include <crypta/lib/python/native_yt/cpp/proto.h>

#include <library/cpp/yson/node/node_io.h>
#include <mapreduce/library/io/proto/proto.h>

#include <util/generic/hash_set.h>
#include <util/generic/map.h>
#include <util/generic/set.h>
#include <util/string/cast.h>

#include <iostream>

using namespace NYT;
using namespace NAudience;

class TMatchWithUserData: public IReducer<TTableReader<TPrunedUserData>, TTableWriter<TUserDataWithSegments>> {
public:
    void Do(TTableReader<TPrunedUserData>* input, TTableWriter<TUserDataWithSegments>* output) override;
};

class TCountMapper: public IMapper<TTableReader<TCountedSegmentID>, TTableWriter<TCountedSegmentID>> {
public:
    TCountMapper()
        : Counts()
    {
    }
    void Start(TTableWriter<TCountedSegmentID>*) override;
    void Do(TTableReader<TCountedSegmentID>* input, TTableWriter<TCountedSegmentID>*) override;
    void Finish(TTableWriter<TCountedSegmentID>* output) override;

private:
    TMap<ui64, ui64> Counts;
};

class TCountReducer: public IReducer<TTableReader<TCountedSegmentID>, TTableWriter<TCountedSegmentID>> {
public:
    void Do(TTableReader<TCountedSegmentID>* input, TTableWriter<TCountedSegmentID>* output);
};

class TTransformCountsToStats: public IMapper<TTableReader<TCountedSegmentID>, TTableWriter<NLab::TUserDataStats>> {
public:
    void Do(TTableReader<TCountedSegmentID>* input, TTableWriter<NLab::TUserDataStats>* output) override;
};

class TMergeStatsWithCounts: public IReducer<TTableReader<NLab::TUserDataStats>, TTableWriter<NLab::TUserDataStats>> {
public:
    void Do(TTableReader<NLab::TUserDataStats>* input, TTableWriter<NLab::TUserDataStats>* output) override;
};

class TExtractGeoStorageOutput: public TStateful<TExportGeoToStorageState, IMapper<TTableReader<TInput>, TTableWriter<TStorageOutput>>> {
public:
    TExtractGeoStorageOutput()
        : TStateful()
    {
    }
    TExtractGeoStorageOutput(const TBuffer& buffer)
        : TStateful(buffer)
    {
    }

    void Start(TTableWriter<TStorageOutput>*) override;
    void Do(TTableReader<TInput>* input, TTableWriter<TStorageOutput>* output) override;

private:
    THashSet<ui64> OutputSegments{};
};

class TSplitUserDataToSegmentStats: public TStateful<NLab::TUserDataStatsOptions, IMapper<TTableReader<TUserDataWithSegments>, TTableWriter<NLab::TUserDataStats>>> {
public:
    TSplitUserDataToSegmentStats()
        : TStateful()
        , Aggregator(State)
        , AggregateSegmentsFlag(false)
    {
    }
    TSplitUserDataToSegmentStats(const TBuffer& buffer)
        : TStateful(buffer)
        , Aggregator(State)
        , AggregateSegmentsFlag(false)
    {
    }

    void Start(TTableWriter<NLab::TUserDataStats>*) override;
    void Do(TTableReader<TUserDataWithSegments>* input, TTableWriter<NLab::TUserDataStats>* output) override;
    void Finish(TTableWriter<NLab::TUserDataStats>* output) override;

private:
    NLab::TSegmentsUserDataStatsAggregator Aggregator;
    bool AggregateSegmentsFlag;
};
